/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.operations.OperationResponse;
import shadow.com.google.gson.annotations.SerializedName;

public class AllowTrustOperationResponse
extends OperationResponse {
    @SerializedName(value="trustor")
    protected final String trustor;
    @SerializedName(value="trustee")
    protected final String trustee;
    @SerializedName(value="asset_type")
    protected final String assetType;
    @SerializedName(value="asset_code")
    protected final String assetCode;
    @SerializedName(value="asset_issuer")
    protected final String assetIssuer;
    @SerializedName(value="authorize")
    protected final boolean authorize;
    @SerializedName(value="authorize_to_maintain_liabilities")
    protected final boolean authorizeToMaintainLiabilities;

    AllowTrustOperationResponse(boolean authorize, boolean authorizeToMaintainLiabilities, String assetIssuer, String assetCode, String assetType, String trustee, String trustor) {
        this.authorize = authorize;
        this.authorizeToMaintainLiabilities = authorizeToMaintainLiabilities;
        this.assetIssuer = assetIssuer;
        this.assetCode = assetCode;
        this.assetType = assetType;
        this.trustee = trustee;
        this.trustor = trustor;
    }

    public String getTrustor() {
        return this.trustor;
    }

    public String getTrustee() {
        return this.trustee;
    }

    public boolean isAuthorize() {
        return this.authorize;
    }

    public boolean isAuthorizedToMaintainLiabilities() {
        return this.authorizeToMaintainLiabilities;
    }

    public Asset getAsset() {
        if (this.assetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.assetCode, this.assetIssuer);
    }
}

