/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.effects;

import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.effects.EffectResponse;
import shadow.com.google.gson.annotations.SerializedName;

public class TradeEffectResponse
extends EffectResponse {
    @SerializedName(value="seller")
    protected final String seller;
    @SerializedName(value="offer_id")
    protected final Long offerId;
    @SerializedName(value="sold_amount")
    protected final String soldAmount;
    @SerializedName(value="sold_asset_type")
    protected final String soldAssetType;
    @SerializedName(value="sold_asset_code")
    protected final String soldAssetCode;
    @SerializedName(value="sold_asset_issuer")
    protected final String soldAssetIssuer;
    @SerializedName(value="bought_amount")
    protected final String boughtAmount;
    @SerializedName(value="bought_asset_type")
    protected final String boughtAssetType;
    @SerializedName(value="bought_asset_code")
    protected final String boughtAssetCode;
    @SerializedName(value="bought_asset_issuer")
    protected final String boughtAssetIssuer;

    TradeEffectResponse(String seller, Long offerId, String soldAmount, String soldAssetType, String soldAssetCode, String soldAssetIssuer, String boughtAmount, String boughtAssetType, String boughtAssetCode, String boughtAssetIssuer) {
        this.seller = seller;
        this.offerId = offerId;
        this.soldAmount = soldAmount;
        this.soldAssetType = soldAssetType;
        this.soldAssetCode = soldAssetCode;
        this.soldAssetIssuer = soldAssetIssuer;
        this.boughtAmount = boughtAmount;
        this.boughtAssetType = boughtAssetType;
        this.boughtAssetCode = boughtAssetCode;
        this.boughtAssetIssuer = boughtAssetIssuer;
    }

    public String getSeller() {
        return this.seller;
    }

    public Long getOfferId() {
        return this.offerId;
    }

    public String getSoldAmount() {
        return this.soldAmount;
    }

    public String getBoughtAmount() {
        return this.boughtAmount;
    }

    public Asset getSoldAsset() {
        if (this.soldAssetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.soldAssetCode, this.soldAssetIssuer);
    }

    public Asset getBoughtAsset() {
        if (this.boughtAssetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.boughtAssetCode, this.boughtAssetIssuer);
    }
}

