/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import java.util.List;
import org.stellar.sdk.Memo;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;
import shadow.com.google.common.base.Optional;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.gson.annotations.SerializedName;

public class TransactionResponse
extends Response
implements Pageable {
    @SerializedName(value="hash")
    private final String hash;
    @SerializedName(value="ledger")
    private final Long ledger;
    @SerializedName(value="created_at")
    private final String createdAt;
    @SerializedName(value="source_account")
    private final String sourceAccount;
    @SerializedName(value="fee_account")
    private final String feeAccount;
    @SerializedName(value="successful")
    private final Boolean successful;
    @SerializedName(value="paging_token")
    private final String pagingToken;
    @SerializedName(value="source_account_sequence")
    private final Long sourceAccountSequence;
    @SerializedName(value="max_fee")
    private final Long maxFee;
    @SerializedName(value="fee_charged")
    private final Long feeCharged;
    @SerializedName(value="operation_count")
    private final Integer operationCount;
    @SerializedName(value="envelope_xdr")
    private final String envelopeXdr;
    @SerializedName(value="result_xdr")
    private final String resultXdr;
    @SerializedName(value="result_meta_xdr")
    private final String resultMetaXdr;
    @SerializedName(value="signatures")
    private final List<String> signatures;
    @SerializedName(value="fee_bump_transaction")
    private final FeeBumpTransaction feeBumpTransaction;
    @SerializedName(value="inner_transaction")
    private final InnerTransaction innerTransaction;
    @SerializedName(value="_links")
    private final Links links;
    private transient Memo memo;

    TransactionResponse(String hash, Long ledger, String createdAt, String sourceAccount, String feeAccount, Boolean successful, String pagingToken, Long sourceAccountSequence, Long maxFee, Long feeCharged, Integer operationCount, String envelopeXdr, String resultXdr, String resultMetaXdr, Memo memo, List<String> signatures, FeeBumpTransaction feeBumpTransaction, InnerTransaction innerTransaction, Links links) {
        this.hash = hash;
        this.ledger = ledger;
        this.createdAt = createdAt;
        this.sourceAccount = sourceAccount;
        this.feeAccount = feeAccount;
        this.successful = successful;
        this.pagingToken = pagingToken;
        this.sourceAccountSequence = sourceAccountSequence;
        this.maxFee = maxFee;
        this.feeCharged = feeCharged;
        this.operationCount = operationCount;
        this.envelopeXdr = envelopeXdr;
        this.resultXdr = resultXdr;
        this.resultMetaXdr = resultMetaXdr;
        this.memo = memo;
        this.signatures = signatures;
        this.feeBumpTransaction = feeBumpTransaction;
        this.innerTransaction = innerTransaction;
        this.links = links;
    }

    public String getHash() {
        return this.hash;
    }

    public Long getLedger() {
        return this.ledger;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public String getFeeAccount() {
        return this.feeAccount;
    }

    public List<String> getSignatures() {
        return this.signatures;
    }

    public Optional<FeeBumpTransaction> getFeeBump() {
        return Optional.fromNullable(this.feeBumpTransaction);
    }

    public Optional<InnerTransaction> getInner() {
        return Optional.fromNullable(this.innerTransaction);
    }

    @Override
    public String getPagingToken() {
        return this.pagingToken;
    }

    public Boolean isSuccessful() {
        return this.successful;
    }

    public Long getSourceAccountSequence() {
        return this.sourceAccountSequence;
    }

    public Long getMaxFee() {
        return this.maxFee;
    }

    public Long getFeeCharged() {
        return this.feeCharged;
    }

    public Integer getOperationCount() {
        return this.operationCount;
    }

    public String getEnvelopeXdr() {
        return this.envelopeXdr;
    }

    public String getResultXdr() {
        return this.resultXdr;
    }

    public String getResultMetaXdr() {
        return this.resultMetaXdr;
    }

    public Memo getMemo() {
        return this.memo;
    }

    public void setMemo(Memo memo) {
        memo = Preconditions.checkNotNull(memo, "memo cannot be null");
        if (this.memo != null) {
            throw new RuntimeException("Memo has been already set.");
        }
        this.memo = memo;
    }

    public Links getLinks() {
        return this.links;
    }

    public static class Links {
        @SerializedName(value="account")
        private final Link account;
        @SerializedName(value="effects")
        private final Link effects;
        @SerializedName(value="ledger")
        private final Link ledger;
        @SerializedName(value="operations")
        private final Link operations;
        @SerializedName(value="precedes")
        private final Link precedes;
        @SerializedName(value="self")
        private final Link self;
        @SerializedName(value="succeeds")
        private final Link succeeds;

        Links(Link account, Link effects, Link ledger, Link operations, Link self, Link precedes, Link succeeds) {
            this.account = account;
            this.effects = effects;
            this.ledger = ledger;
            this.operations = operations;
            this.self = self;
            this.precedes = precedes;
            this.succeeds = succeeds;
        }

        public Link getAccount() {
            return this.account;
        }

        public Link getEffects() {
            return this.effects;
        }

        public Link getLedger() {
            return this.ledger;
        }

        public Link getOperations() {
            return this.operations;
        }

        public Link getPrecedes() {
            return this.precedes;
        }

        public Link getSelf() {
            return this.self;
        }

        public Link getSucceeds() {
            return this.succeeds;
        }
    }

    public static class InnerTransaction {
        @SerializedName(value="hash")
        private final String hash;
        @SerializedName(value="signatures")
        private final List<String> signatures;
        @SerializedName(value="max_fee")
        private final Long maxFee;

        InnerTransaction(String hash, List<String> signatures, Long maxFee) {
            this.hash = hash;
            this.signatures = signatures;
            this.maxFee = maxFee;
        }

        public String getHash() {
            return this.hash;
        }

        public List<String> getSignatures() {
            return this.signatures;
        }

        public Long getMaxFee() {
            return this.maxFee;
        }
    }

    public static class FeeBumpTransaction {
        @SerializedName(value="hash")
        private final String hash;
        @SerializedName(value="signatures")
        private final List<String> signatures;

        FeeBumpTransaction(String hash, List<String> signatures) {
            this.hash = hash;
            this.signatures = signatures;
        }

        public String getHash() {
            return this.hash;
        }

        public List<String> getSignatures() {
            return this.signatures;
        }
    }
}

