/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import org.stellar.sdk.Asset;
import org.stellar.sdk.Price;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;
import shadow.com.google.gson.annotations.SerializedName;

public class TradeResponse
extends Response
implements Pageable {
    @SerializedName(value="id")
    private final String id;
    @SerializedName(value="paging_token")
    private final String pagingToken;
    @SerializedName(value="ledger_close_time")
    private final String ledgerCloseTime;
    @SerializedName(value="offer_id")
    private final String offerId;
    @SerializedName(value="base_is_seller")
    protected final boolean baseIsSeller;
    @SerializedName(value="base_account")
    protected final String baseAccount;
    @SerializedName(value="base_offer_id")
    private final String baseOfferId;
    @SerializedName(value="base_amount")
    protected final String baseAmount;
    @SerializedName(value="base_asset_type")
    protected final String baseAssetType;
    @SerializedName(value="base_asset_code")
    protected final String baseAssetCode;
    @SerializedName(value="base_asset_issuer")
    protected final String baseAssetIssuer;
    @SerializedName(value="counter_account")
    protected final String counterAccount;
    @SerializedName(value="counter_offer_id")
    private final String counterOfferId;
    @SerializedName(value="counter_amount")
    protected final String counterAmount;
    @SerializedName(value="counter_asset_type")
    protected final String counterAssetType;
    @SerializedName(value="counter_asset_code")
    protected final String counterAssetCode;
    @SerializedName(value="counter_asset_issuer")
    protected final String counterAssetIssuer;
    @SerializedName(value="price")
    protected final Price price;
    @SerializedName(value="_links")
    private Links links;

    public TradeResponse(String id, String pagingToken, String ledgerCloseTime, String offerId, boolean baseIsSeller, String baseAccount, String baseOfferId, String baseAmount, String baseAssetType, String baseAssetCode, String baseAssetIssuer, String counterAccount, String counterOfferId, String counterAmount, String counterAssetType, String counterAssetCode, String counterAssetIssuer, Price price) {
        this.id = id;
        this.pagingToken = pagingToken;
        this.ledgerCloseTime = ledgerCloseTime;
        this.offerId = offerId;
        this.baseIsSeller = baseIsSeller;
        this.baseAccount = baseAccount;
        this.baseOfferId = baseOfferId;
        this.baseAmount = baseAmount;
        this.baseAssetType = baseAssetType;
        this.baseAssetCode = baseAssetCode;
        this.baseAssetIssuer = baseAssetIssuer;
        this.counterAccount = counterAccount;
        this.counterOfferId = counterOfferId;
        this.counterAmount = counterAmount;
        this.counterAssetType = counterAssetType;
        this.counterAssetCode = counterAssetCode;
        this.counterAssetIssuer = counterAssetIssuer;
        this.price = price;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getPagingToken() {
        return this.pagingToken;
    }

    public String getLedgerCloseTime() {
        return this.ledgerCloseTime;
    }

    public String getOfferId() {
        return this.offerId;
    }

    public boolean isBaseSeller() {
        return this.baseIsSeller;
    }

    public String getBaseOfferId() {
        return this.baseOfferId;
    }

    public String getBaseAccount() {
        return this.baseAccount;
    }

    public String getBaseAmount() {
        return this.baseAmount;
    }

    public Asset getBaseAsset() {
        return Asset.create(this.baseAssetType, this.baseAssetCode, this.baseAssetIssuer);
    }

    public String getBaseAssetType() {
        return this.baseAssetType;
    }

    public String getBaseAssetCode() {
        return this.baseAssetCode;
    }

    public String getBaseAssetIssuer() {
        return this.baseAssetIssuer;
    }

    public String getCounterAccount() {
        return this.counterAccount;
    }

    public String getCounterOfferId() {
        return this.counterOfferId;
    }

    public Asset getCounterAsset() {
        return Asset.create(this.counterAssetType, this.counterAssetCode, this.counterAssetIssuer);
    }

    public String getCounterAmount() {
        return this.counterAmount;
    }

    public String getCounterAssetType() {
        return this.counterAssetType;
    }

    public String getCounterAssetCode() {
        return this.counterAssetCode;
    }

    public String getCounterAssetIssuer() {
        return this.counterAssetIssuer;
    }

    public Price getPrice() {
        return this.price;
    }

    public Links getLinks() {
        return this.links;
    }

    public static class Links {
        @SerializedName(value="base")
        private final Link base;
        @SerializedName(value="counter")
        private final Link counter;
        @SerializedName(value="operation")
        private final Link operation;

        public Links(Link base, Link counter, Link operation) {
            this.base = base;
            this.counter = counter;
            this.operation = operation;
        }

        public Link getBase() {
            return this.base;
        }

        public Link getCounter() {
            return this.counter;
        }

        public Link getOperation() {
            return this.operation;
        }
    }
}

