/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import org.stellar.sdk.Asset;
import org.stellar.sdk.Price;
import org.stellar.sdk.responses.Response;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.gson.annotations.SerializedName;

public class OrderBookResponse
extends Response {
    @SerializedName(value="base")
    private final Asset base;
    @SerializedName(value="counter")
    private final Asset counter;
    @SerializedName(value="asks")
    private final Row[] asks;
    @SerializedName(value="bids")
    private final Row[] bids;

    public OrderBookResponse(Asset base, Asset counter, Row[] asks, Row[] bids) {
        this.base = base;
        this.counter = counter;
        this.asks = asks;
        this.bids = bids;
    }

    public Asset getBase() {
        return this.base;
    }

    public Asset getCounter() {
        return this.counter;
    }

    public Row[] getAsks() {
        return this.asks;
    }

    public Row[] getBids() {
        return this.bids;
    }

    public static class Row {
        @SerializedName(value="amount")
        private final String amount;
        @SerializedName(value="price")
        private final String price;
        @SerializedName(value="price_r")
        private final Price priceR;

        Row(String amount, String price, Price priceR) {
            this.amount = Preconditions.checkNotNull(amount, "amount cannot be null");
            this.price = Preconditions.checkNotNull(price, "price cannot be null");
            this.priceR = Preconditions.checkNotNull(priceR, "priceR cannot be null");
        }

        public String getAmount() {
            return this.amount;
        }

        public String getPrice() {
            return this.price;
        }

        public Price getPriceR() {
            return this.priceR;
        }
    }
}

