/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import java.lang.reflect.Type;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Predicate;
import org.stellar.sdk.responses.AssetDeserializer;
import org.stellar.sdk.responses.PredicateDeserializer;
import org.stellar.sdk.responses.TransactionDeserializer;
import org.stellar.sdk.responses.TransactionResponse;
import org.stellar.sdk.responses.operations.AccountMergeOperationResponse;
import org.stellar.sdk.responses.operations.AllowTrustOperationResponse;
import org.stellar.sdk.responses.operations.BeginSponsoringFutureReservesOperationResponse;
import org.stellar.sdk.responses.operations.BumpSequenceOperationResponse;
import org.stellar.sdk.responses.operations.ChangeTrustOperationResponse;
import org.stellar.sdk.responses.operations.ClaimClaimableBalanceOperationResponse;
import org.stellar.sdk.responses.operations.CreateAccountOperationResponse;
import org.stellar.sdk.responses.operations.CreateClaimableBalanceOperationResponse;
import org.stellar.sdk.responses.operations.CreatePassiveSellOfferOperationResponse;
import org.stellar.sdk.responses.operations.EndSponsoringFutureReservesOperationResponse;
import org.stellar.sdk.responses.operations.InflationOperationResponse;
import org.stellar.sdk.responses.operations.ManageBuyOfferOperationResponse;
import org.stellar.sdk.responses.operations.ManageDataOperationResponse;
import org.stellar.sdk.responses.operations.ManageSellOfferOperationResponse;
import org.stellar.sdk.responses.operations.OperationResponse;
import org.stellar.sdk.responses.operations.PathPaymentStrictReceiveOperationResponse;
import org.stellar.sdk.responses.operations.PathPaymentStrictSendOperationResponse;
import org.stellar.sdk.responses.operations.PaymentOperationResponse;
import org.stellar.sdk.responses.operations.RevokeSponsorshipOperationResponse;
import org.stellar.sdk.responses.operations.SetOptionsOperationResponse;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.gson.Gson;
import shadow.com.google.gson.GsonBuilder;
import shadow.com.google.gson.JsonDeserializationContext;
import shadow.com.google.gson.JsonDeserializer;
import shadow.com.google.gson.JsonElement;
import shadow.com.google.gson.JsonParseException;

class OperationDeserializer
implements JsonDeserializer<OperationResponse> {
    private static final OperationType[] AllOperationTypes = OperationType.values();

    OperationDeserializer() {
    }

    @Override
    public OperationResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Asset.class), new AssetDeserializer()).registerTypeAdapter((Type)((Object)Predicate.class), new PredicateDeserializer()).registerTypeAdapter((Type)((Object)TransactionResponse.class), new TransactionDeserializer()).create();
        int type = json.getAsJsonObject().get("type_i").getAsInt();
        if (type < 0 || type >= AllOperationTypes.length) {
            throw new RuntimeException("Invalid operation type");
        }
        switch (AllOperationTypes[type]) {
            case CREATE_ACCOUNT: {
                return gson.fromJson(json, CreateAccountOperationResponse.class);
            }
            case PAYMENT: {
                return gson.fromJson(json, PaymentOperationResponse.class);
            }
            case PATH_PAYMENT_STRICT_RECEIVE: {
                return gson.fromJson(json, PathPaymentStrictReceiveOperationResponse.class);
            }
            case MANAGE_SELL_OFFER: {
                return gson.fromJson(json, ManageSellOfferOperationResponse.class);
            }
            case CREATE_PASSIVE_SELL_OFFER: {
                return gson.fromJson(json, CreatePassiveSellOfferOperationResponse.class);
            }
            case SET_OPTIONS: {
                return gson.fromJson(json, SetOptionsOperationResponse.class);
            }
            case CHANGE_TRUST: {
                return gson.fromJson(json, ChangeTrustOperationResponse.class);
            }
            case ALLOW_TRUST: {
                return gson.fromJson(json, AllowTrustOperationResponse.class);
            }
            case ACCOUNT_MERGE: {
                return gson.fromJson(json, AccountMergeOperationResponse.class);
            }
            case INFLATION: {
                return gson.fromJson(json, InflationOperationResponse.class);
            }
            case MANAGE_DATA: {
                return gson.fromJson(json, ManageDataOperationResponse.class);
            }
            case BUMP_SEQUENCE: {
                return gson.fromJson(json, BumpSequenceOperationResponse.class);
            }
            case MANAGE_BUY_OFFER: {
                return gson.fromJson(json, ManageBuyOfferOperationResponse.class);
            }
            case PATH_PAYMENT_STRICT_SEND: {
                return gson.fromJson(json, PathPaymentStrictSendOperationResponse.class);
            }
            case CREATE_CLAIMABLE_BALANCE: {
                return gson.fromJson(json, CreateClaimableBalanceOperationResponse.class);
            }
            case CLAIM_CLAIMABLE_BALANCE: {
                return gson.fromJson(json, ClaimClaimableBalanceOperationResponse.class);
            }
            case BEGIN_SPONSORING_FUTURE_RESERVES: {
                return gson.fromJson(json, BeginSponsoringFutureReservesOperationResponse.class);
            }
            case END_SPONSORING_FUTURE_RESERVES: {
                return gson.fromJson(json, EndSponsoringFutureReservesOperationResponse.class);
            }
            case REVOKE_SPONSORSHIP: {
                return gson.fromJson(json, RevokeSponsorshipOperationResponse.class);
            }
        }
        throw new RuntimeException("Invalid operation type");
    }
}

