/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import org.stellar.sdk.Asset;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;
import shadow.com.google.gson.annotations.SerializedName;

public class AssetResponse
extends Response
implements Pageable {
    @SerializedName(value="asset_type")
    private final String assetType;
    @SerializedName(value="asset_code")
    private final String assetCode;
    @SerializedName(value="asset_issuer")
    private final String assetIssuer;
    @SerializedName(value="paging_token")
    private final String pagingToken;
    @SerializedName(value="amount")
    private final String amount;
    @SerializedName(value="num_accounts")
    private final int numAccounts;
    @SerializedName(value="flags")
    private final Flags flags;
    @SerializedName(value="_links")
    private final Links links;

    public AssetResponse(String assetType, String assetCode, String assetIssuer, String pagingToken, String amount, int numAccounts, Flags flags, Links links) {
        this.assetType = assetType;
        this.assetCode = assetCode;
        this.assetIssuer = assetIssuer;
        this.pagingToken = pagingToken;
        this.amount = amount;
        this.numAccounts = numAccounts;
        this.flags = flags;
        this.links = links;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public String getAssetCode() {
        return this.assetCode;
    }

    public String getAssetIssuer() {
        return this.assetIssuer;
    }

    public Asset getAsset() {
        return Asset.create(this.assetType, this.assetCode, this.assetIssuer);
    }

    @Override
    public String getPagingToken() {
        return this.pagingToken;
    }

    public String getAmount() {
        return this.amount;
    }

    public int getNumAccounts() {
        return this.numAccounts;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public Links getLinks() {
        return this.links;
    }

    public static class Links {
        @SerializedName(value="toml")
        private final Link toml;

        public Links(Link toml) {
            this.toml = toml;
        }

        public Link getToml() {
            return this.toml;
        }
    }

    public static class Flags {
        @SerializedName(value="auth_required")
        private final boolean authRequired;
        @SerializedName(value="auth_revocable")
        private final boolean authRevocable;

        public Flags(boolean authRequired, boolean authRevocable) {
            this.authRequired = authRequired;
            this.authRevocable = authRevocable;
        }

        public boolean isAuthRequired() {
            return this.authRequired;
        }

        public boolean isAuthRevocable() {
            return this.authRevocable;
        }
    }
}

