/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import java.util.HashMap;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Response;
import shadow.com.google.common.base.Optional;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.io.BaseEncoding;
import shadow.com.google.gson.annotations.SerializedName;

public class AccountResponse
extends Response
implements TransactionBuilderAccount {
    @SerializedName(value="account_id")
    private String accountId;
    @SerializedName(value="sequence")
    private Long sequenceNumber;
    @SerializedName(value="subentry_count")
    private Integer subentryCount;
    @SerializedName(value="inflation_destination")
    private String inflationDestination;
    @SerializedName(value="home_domain")
    private String homeDomain;
    @SerializedName(value="last_modified_ledger")
    private Integer lastModifiedLedger;
    @SerializedName(value="thresholds")
    private Thresholds thresholds;
    @SerializedName(value="flags")
    private Flags flags;
    @SerializedName(value="balances")
    private Balance[] balances;
    @SerializedName(value="signers")
    private Signer[] signers;
    @SerializedName(value="data")
    private Data data;
    @SerializedName(value="_links")
    private Links links;
    @SerializedName(value="num_sponsoring")
    private Integer numSponsoring;
    @SerializedName(value="num_sponsored")
    private Integer numSponsored;
    @SerializedName(value="sponsor")
    private String sponsor;

    AccountResponse(String accountId) {
        this.accountId = accountId;
    }

    public AccountResponse(String accountId, Long sequenceNumber) {
        this.accountId = accountId;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public KeyPair getKeyPair() {
        return KeyPair.fromAccountId(this.accountId);
    }

    @Override
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public Long getIncrementedSequenceNumber() {
        return new Long(this.sequenceNumber + 1L);
    }

    @Override
    public void incrementSequenceNumber() {
        Long l = this.sequenceNumber;
        Long l2 = this.sequenceNumber = Long.valueOf(this.sequenceNumber + 1L);
    }

    public Integer getSubentryCount() {
        return this.subentryCount;
    }

    public String getInflationDestination() {
        return this.inflationDestination;
    }

    public String getHomeDomain() {
        return this.homeDomain;
    }

    public Integer getLastModifiedLedger() {
        return this.lastModifiedLedger;
    }

    public Thresholds getThresholds() {
        return this.thresholds;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public Balance[] getBalances() {
        return this.balances;
    }

    public Signer[] getSigners() {
        return this.signers;
    }

    public Data getData() {
        return this.data;
    }

    public Integer getNumSponsoring() {
        return this.numSponsoring;
    }

    public Integer getNumSponsored() {
        return this.numSponsored;
    }

    public Optional<String> getSponsor() {
        return Optional.fromNullable(this.sponsor);
    }

    public Links getLinks() {
        return this.links;
    }

    public static class Links {
        @SerializedName(value="effects")
        private final Link effects;
        @SerializedName(value="offers")
        private final Link offers;
        @SerializedName(value="operations")
        private final Link operations;
        @SerializedName(value="self")
        private final Link self;
        @SerializedName(value="transactions")
        private final Link transactions;

        Links(Link effects, Link offers, Link operations, Link self, Link transactions) {
            this.effects = effects;
            this.offers = offers;
            this.operations = operations;
            this.self = self;
            this.transactions = transactions;
        }

        public Link getEffects() {
            return this.effects;
        }

        public Link getOffers() {
            return this.offers;
        }

        public Link getOperations() {
            return this.operations;
        }

        public Link getSelf() {
            return this.self;
        }

        public Link getTransactions() {
            return this.transactions;
        }
    }

    public static class Data
    extends HashMap<String, String> {
        @Override
        public int size() {
            return super.size();
        }

        public String get(String key) {
            return (String)super.get(key);
        }

        public byte[] getDecoded(String key) {
            BaseEncoding base64Encoding = BaseEncoding.base64();
            return base64Encoding.decode(this.get(key));
        }
    }

    public static class Signer {
        @SerializedName(value="key")
        private final String key;
        @SerializedName(value="type")
        private final String type;
        @SerializedName(value="weight")
        private final int weight;
        @SerializedName(value="sponsor")
        private String sponsor;

        Signer(String key, String type, int weight, String sponsor) {
            this.key = Preconditions.checkNotNull(key, "key cannot be null");
            this.type = Preconditions.checkNotNull(type, "type cannot be null");
            this.weight = Preconditions.checkNotNull(weight, "weight cannot be null");
            this.sponsor = sponsor;
        }

        public String getAccountId() {
            return this.key;
        }

        public String getKey() {
            return this.key;
        }

        public int getWeight() {
            return this.weight;
        }

        public String getType() {
            return this.type;
        }

        public Optional<String> getSponsor() {
            return Optional.fromNullable(this.sponsor);
        }
    }

    public static class Balance {
        @SerializedName(value="asset_type")
        private final String assetType;
        @SerializedName(value="asset_code")
        private final String assetCode;
        @SerializedName(value="asset_issuer")
        private final String assetIssuer;
        @SerializedName(value="limit")
        private final String limit;
        @SerializedName(value="balance")
        private final String balance;
        @SerializedName(value="buying_liabilities")
        private final String buyingLiabilities;
        @SerializedName(value="selling_liabilities")
        private final String sellingLiabilities;
        @SerializedName(value="is_authorized")
        private final Boolean isAuthorized;
        @SerializedName(value="is_authorized_to_maintain_liabilities")
        private final Boolean isAuthorizedToMaintainLiabilities;
        @SerializedName(value="last_modified_ledger")
        private final Integer lastModifiedLedger;
        @SerializedName(value="sponsor")
        private String sponsor;

        Balance(String assetType, String assetCode, String assetIssuer, String balance, String limit, String buyingLiabilities, String sellingLiabilities, Boolean isAuthorized, Boolean isAuthorizedToMaintainLiabilities, Integer lastModifiedLedger, String sponsor) {
            this.assetType = Preconditions.checkNotNull(assetType, "assertType cannot be null");
            this.balance = Preconditions.checkNotNull(balance, "balance cannot be null");
            this.limit = limit;
            this.assetCode = assetCode;
            this.assetIssuer = assetIssuer;
            this.buyingLiabilities = Preconditions.checkNotNull(buyingLiabilities, "buyingLiabilities cannot be null");
            this.sellingLiabilities = Preconditions.checkNotNull(sellingLiabilities, "sellingLiabilities cannot be null");
            this.isAuthorized = isAuthorized;
            this.isAuthorizedToMaintainLiabilities = isAuthorizedToMaintainLiabilities;
            this.lastModifiedLedger = lastModifiedLedger;
            this.sponsor = sponsor;
        }

        public Asset getAsset() {
            if (this.assetType.equals("native")) {
                return new AssetTypeNative();
            }
            return Asset.createNonNativeAsset(this.assetCode, this.getAssetIssuer());
        }

        public String getAssetType() {
            return this.assetType;
        }

        public String getAssetCode() {
            return this.assetCode;
        }

        public String getAssetIssuer() {
            return this.assetIssuer;
        }

        public String getBalance() {
            return this.balance;
        }

        public String getBuyingLiabilities() {
            return this.buyingLiabilities;
        }

        public String getSellingLiabilities() {
            return this.sellingLiabilities;
        }

        public String getLimit() {
            return this.limit;
        }

        public Boolean getAuthorized() {
            return this.isAuthorized;
        }

        public Boolean getAuthorizedToMaintainLiabilities() {
            return this.isAuthorizedToMaintainLiabilities;
        }

        public Integer getLastModifiedLedger() {
            return this.lastModifiedLedger;
        }

        public Optional<String> getSponsor() {
            return Optional.fromNullable(this.sponsor);
        }
    }

    public static class Flags {
        @SerializedName(value="auth_required")
        private final boolean authRequired;
        @SerializedName(value="auth_revocable")
        private final boolean authRevocable;
        @SerializedName(value="auth_immutable")
        private final boolean authImmutable;

        Flags(boolean authRequired, boolean authRevocable, boolean authImmutable) {
            this.authRequired = authRequired;
            this.authRevocable = authRevocable;
            this.authImmutable = authImmutable;
        }

        public boolean getAuthRequired() {
            return this.authRequired;
        }

        public boolean getAuthRevocable() {
            return this.authRevocable;
        }

        public boolean getAuthImmutable() {
            return this.authImmutable;
        }
    }

    public static class Thresholds {
        @SerializedName(value="low_threshold")
        private final int lowThreshold;
        @SerializedName(value="med_threshold")
        private final int medThreshold;
        @SerializedName(value="high_threshold")
        private final int highThreshold;

        Thresholds(int lowThreshold, int medThreshold, int highThreshold) {
            this.lowThreshold = lowThreshold;
            this.medThreshold = medThreshold;
            this.highThreshold = highThreshold;
        }

        public int getLowThreshold() {
            return this.lowThreshold;
        }

        public int getMedThreshold() {
            return this.medThreshold;
        }

        public int getHighThreshold() {
            return this.highThreshold;
        }
    }
}

