/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import java.io.IOException;
import org.stellar.sdk.requests.ErrorResponse;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.GsonSingleton;
import org.stellar.sdk.responses.TypedResponse;
import shadow.com.google.gson.reflect.TypeToken;
import shadow.okhttp3.Response;

public class ResponseHandler<T> {
    private TypeToken<T> type;

    public ResponseHandler(TypeToken<T> type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T handleResponse(Response response) throws IOException, TooManyRequestsException {
        try {
            if (response.code() == 429) {
                int retryAfter = Integer.parseInt(response.header("Retry-After"));
                throw new TooManyRequestsException(retryAfter);
            }
            String content = response.body().string();
            if (response.code() >= 300) {
                throw new ErrorResponse(response.code(), content);
            }
            Object object = GsonSingleton.getInstance().fromJson(content, this.type.getType());
            if (object instanceof org.stellar.sdk.responses.Response) {
                ((org.stellar.sdk.responses.Response)object).setHeaders(response.headers());
            }
            if (object instanceof TypedResponse) {
                ((TypedResponse)object).setType(this.type);
            }
            Object t = object;
            return t;
        }
        finally {
            response.close();
        }
    }
}

