/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.Memo;
import org.stellar.sdk.Network;
import org.stellar.sdk.NoNetworkSelectedException;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.Transaction;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionSignaturePayload;
import org.stellar.sdk.xdr.TransactionV0;
import org.stellar.sdk.xdr.TransactionV0Envelope;
import org.stellar.sdk.xdr.TransactionV1Envelope;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class Transaction
extends AbstractTransaction {
    private final long mFee;
    private final String mSourceAccount;
    private final long mSequenceNumber;
    private final Operation[] mOperations;
    private final Memo mMemo;
    private final TimeBounds mTimeBounds;
    private EnvelopeType envelopeType = EnvelopeType.ENVELOPE_TYPE_TX;

    Transaction(String sourceAccount, long fee, long sequenceNumber, Operation[] operations, Memo memo, TimeBounds timeBounds, Network network) {
        super(network);
        this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
        this.mSequenceNumber = Preconditions.checkNotNull(sequenceNumber, "sequenceNumber cannot be null");
        this.mOperations = Preconditions.checkNotNull(operations, "operations cannot be null");
        Preconditions.checkArgument(operations.length > 0, "At least one operation required");
        this.mFee = fee;
        this.mMemo = memo != null ? memo : Memo.none();
        this.mTimeBounds = timeBounds;
    }

    void setEnvelopeType(EnvelopeType envelopeType) {
        this.envelopeType = envelopeType;
    }

    @Override
    public byte[] signatureBase() {
        try {
            TransactionSignaturePayload payload = new TransactionSignaturePayload();
            TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction taggedTransaction = new TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction();
            taggedTransaction.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX);
            taggedTransaction.setTx(this.toV1Xdr());
            Hash hash = new Hash();
            hash.setHash(this.mNetwork.getNetworkId());
            payload.setNetworkId(hash);
            payload.setTaggedTransaction(taggedTransaction);
            ByteArrayOutputStream txOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrOutputStream = new XdrDataOutputStream(txOutputStream);
            payload.encode(xdrOutputStream);
            return txOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSourceAccount() {
        return this.mSourceAccount;
    }

    public long getSequenceNumber() {
        return this.mSequenceNumber;
    }

    public Memo getMemo() {
        return this.mMemo;
    }

    public TimeBounds getTimeBounds() {
        return this.mTimeBounds;
    }

    public long getFee() {
        return this.mFee;
    }

    public Operation[] getOperations() {
        return this.mOperations;
    }

    private TransactionV0 toXdr() {
        Uint32 fee = new Uint32();
        fee.setUint32((int)this.mFee);
        Int64 sequenceNumberUint = new Int64();
        sequenceNumberUint.setInt64(this.mSequenceNumber);
        SequenceNumber sequenceNumber = new SequenceNumber();
        sequenceNumber.setSequenceNumber(sequenceNumberUint);
        org.stellar.sdk.xdr.Operation[] operations = new org.stellar.sdk.xdr.Operation[this.mOperations.length];
        for (int i = 0; i < this.mOperations.length; ++i) {
            operations[i] = this.mOperations[i].toXdr();
        }
        TransactionV0.TransactionV0Ext ext = new TransactionV0.TransactionV0Ext();
        ext.setDiscriminant(0);
        TransactionV0 transaction = new TransactionV0();
        transaction.setFee(fee);
        transaction.setSeqNum(sequenceNumber);
        transaction.setSourceAccountEd25519(StrKey.encodeToXDRAccountId(this.mSourceAccount).getAccountID().getEd25519());
        transaction.setOperations(operations);
        transaction.setMemo(this.mMemo.toXdr());
        transaction.setTimeBounds(this.mTimeBounds == null ? null : this.mTimeBounds.toXdr());
        transaction.setExt(ext);
        return transaction;
    }

    private org.stellar.sdk.xdr.Transaction toV1Xdr() {
        Uint32 fee = new Uint32();
        fee.setUint32((int)this.mFee);
        Int64 sequenceNumberUint = new Int64();
        sequenceNumberUint.setInt64(this.mSequenceNumber);
        SequenceNumber sequenceNumber = new SequenceNumber();
        sequenceNumber.setSequenceNumber(sequenceNumberUint);
        org.stellar.sdk.xdr.Operation[] operations = new org.stellar.sdk.xdr.Operation[this.mOperations.length];
        for (int i = 0; i < this.mOperations.length; ++i) {
            operations[i] = this.mOperations[i].toXdr();
        }
        Transaction.TransactionExt ext = new Transaction.TransactionExt();
        ext.setDiscriminant(0);
        org.stellar.sdk.xdr.Transaction v1Tx = new org.stellar.sdk.xdr.Transaction();
        v1Tx.setFee(fee);
        v1Tx.setSeqNum(sequenceNumber);
        v1Tx.setSourceAccount(StrKey.encodeToXDRMuxedAccount(this.mSourceAccount));
        v1Tx.setOperations(operations);
        v1Tx.setMemo(this.mMemo.toXdr());
        v1Tx.setTimeBounds(this.mTimeBounds == null ? null : this.mTimeBounds.toXdr());
        v1Tx.setExt(ext);
        return v1Tx;
    }

    public static Transaction fromV0EnvelopeXdr(TransactionV0Envelope envelope, Network network) {
        int mFee = envelope.getTx().getFee().getUint32();
        Long mSequenceNumber = envelope.getTx().getSeqNum().getSequenceNumber().getInt64();
        Memo mMemo = Memo.fromXdr(envelope.getTx().getMemo());
        TimeBounds mTimeBounds = TimeBounds.fromXdr(envelope.getTx().getTimeBounds());
        Operation[] mOperations = new Operation[envelope.getTx().getOperations().length];
        for (int i = 0; i < envelope.getTx().getOperations().length; ++i) {
            mOperations[i] = Operation.fromXdr(envelope.getTx().getOperations()[i]);
        }
        Transaction transaction = new Transaction(StrKey.encodeStellarAccountId(envelope.getTx().getSourceAccountEd25519().getUint256()), mFee, mSequenceNumber, mOperations, mMemo, mTimeBounds, network);
        transaction.setEnvelopeType(EnvelopeType.ENVELOPE_TYPE_TX_V0);
        for (DecoratedSignature signature : envelope.getSignatures()) {
            transaction.mSignatures.add(signature);
        }
        return transaction;
    }

    public static Transaction fromV1EnvelopeXdr(TransactionV1Envelope envelope, Network network) {
        int mFee = envelope.getTx().getFee().getUint32();
        Long mSequenceNumber = envelope.getTx().getSeqNum().getSequenceNumber().getInt64();
        Memo mMemo = Memo.fromXdr(envelope.getTx().getMemo());
        TimeBounds mTimeBounds = TimeBounds.fromXdr(envelope.getTx().getTimeBounds());
        Operation[] mOperations = new Operation[envelope.getTx().getOperations().length];
        for (int i = 0; i < envelope.getTx().getOperations().length; ++i) {
            mOperations[i] = Operation.fromXdr(envelope.getTx().getOperations()[i]);
        }
        Transaction transaction = new Transaction(StrKey.encodeStellarAccountId(StrKey.muxedAccountToAccountId(envelope.getTx().getSourceAccount())), mFee, mSequenceNumber, mOperations, mMemo, mTimeBounds, network);
        for (DecoratedSignature signature : envelope.getSignatures()) {
            transaction.mSignatures.add(signature);
        }
        return transaction;
    }

    @Override
    public TransactionEnvelope toEnvelopeXdr() {
        TransactionEnvelope xdr = new TransactionEnvelope();
        DecoratedSignature[] signatures = new DecoratedSignature[this.mSignatures.size()];
        signatures = this.mSignatures.toArray(signatures);
        if (this.envelopeType == EnvelopeType.ENVELOPE_TYPE_TX) {
            TransactionV1Envelope v1Envelope = new TransactionV1Envelope();
            xdr.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX);
            v1Envelope.setTx(this.toV1Xdr());
            v1Envelope.setSignatures(signatures);
            xdr.setV1(v1Envelope);
        } else if (this.envelopeType == EnvelopeType.ENVELOPE_TYPE_TX_V0) {
            TransactionV0Envelope v0Envelope = new TransactionV0Envelope();
            xdr.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX_V0);
            v0Envelope.setTx(this.toXdr());
            v0Envelope.setSignatures(signatures);
            xdr.setV0(v0Envelope);
        } else {
            throw new RuntimeException("invalid envelope type: " + this.envelopeType);
        }
        return xdr;
    }

    public int hashCode() {
        return Objects.hashCode(this.envelopeType, this.mFee, this.mSourceAccount, this.mSequenceNumber, Arrays.hashCode(this.mOperations), this.mMemo, this.mTimeBounds, this.mSignatures, this.mNetwork);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)object;
        return Objects.equal(this.envelopeType, other.envelopeType) && Objects.equal(this.mFee, other.mFee) && Objects.equal(this.mSourceAccount, other.mSourceAccount) && Objects.equal(this.mSequenceNumber, other.mSequenceNumber) && Arrays.equals(this.mOperations, other.mOperations) && Objects.equal(this.mMemo, other.mMemo) && Objects.equal(this.mTimeBounds, other.mTimeBounds) && Objects.equal(this.mNetwork, other.mNetwork) && Objects.equal(this.mSignatures, other.mSignatures);
    }

    public static class Builder {
        private final TransactionBuilderAccount mSourceAccount;
        private Memo mMemo;
        private TimeBounds mTimeBounds;
        List<Operation> mOperations;
        private boolean timeoutSet;
        private Integer mBaseFee;
        private Network mNetwork;
        public static final long TIMEOUT_INFINITE = 0L;

        public Builder(TransactionBuilderAccount sourceAccount, Network network) {
            Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            this.mSourceAccount = sourceAccount;
            this.mOperations = Collections.synchronizedList(new ArrayList());
            this.mNetwork = Preconditions.checkNotNull(network, "Network cannot be null");
        }

        public int getOperationsCount() {
            return this.mOperations.size();
        }

        public Builder addOperation(Operation operation) {
            Preconditions.checkNotNull(operation, "operation cannot be null");
            this.mOperations.add(operation);
            return this;
        }

        public Builder addMemo(Memo memo) {
            if (this.mMemo != null) {
                throw new RuntimeException("Memo has been already added.");
            }
            Preconditions.checkNotNull(memo, "memo cannot be null");
            this.mMemo = memo;
            return this;
        }

        public Builder addTimeBounds(TimeBounds timeBounds) {
            if (this.mTimeBounds != null) {
                throw new RuntimeException("TimeBounds has been already added.");
            }
            Preconditions.checkNotNull(timeBounds, "timeBounds cannot be null");
            this.mTimeBounds = timeBounds;
            return this;
        }

        public Builder setTimeout(long timeout) {
            if (this.mTimeBounds != null && this.mTimeBounds.getMaxTime() > 0L) {
                throw new RuntimeException("TimeBounds.max_time has been already set - setting timeout would overwrite it.");
            }
            if (timeout < 0L) {
                throw new RuntimeException("timeout cannot be negative");
            }
            this.timeoutSet = true;
            if (timeout > 0L) {
                long timeoutTimestamp = System.currentTimeMillis() / 1000L + timeout;
                this.mTimeBounds = this.mTimeBounds == null ? new TimeBounds(0L, timeoutTimestamp) : new TimeBounds(this.mTimeBounds.getMinTime(), timeoutTimestamp);
            }
            return this;
        }

        public Builder setBaseFee(int baseFee) {
            if (baseFee < 100) {
                throw new IllegalArgumentException("baseFee cannot be smaller than the BASE_FEE (100): " + baseFee);
            }
            this.mBaseFee = baseFee;
            return this;
        }

        public Transaction build() {
            if ((this.mTimeBounds == null || this.mTimeBounds != null && this.mTimeBounds.getMaxTime() == 0L) && !this.timeoutSet) {
                throw new RuntimeException("TimeBounds has to be set or you must call setTimeout(TIMEOUT_INFINITE).");
            }
            if (this.mBaseFee == null) {
                throw new RuntimeException("mBaseFee has to be set. you must call setBaseFee().");
            }
            if (this.mNetwork == null) {
                throw new NoNetworkSelectedException();
            }
            Operation[] operations = new Operation[this.mOperations.size()];
            operations = this.mOperations.toArray(operations);
            Transaction transaction = new Transaction(this.mSourceAccount.getAccountId(), operations.length * this.mBaseFee, this.mSourceAccount.getIncrementedSequenceNumber(), operations, this.mMemo, this.mTimeBounds, this.mNetwork);
            this.mSourceAccount.incrementSequenceNumber();
            return transaction;
        }
    }
}

