/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.stellar.sdk.FormatException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.CryptoKeyType;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.PublicKey;
import org.stellar.sdk.xdr.PublicKeyType;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataInputStream;
import shadow.com.google.common.base.Optional;
import shadow.com.google.common.io.BaseEncoding;

class StrKey {
    public static final int ACCOUNT_ID_ADDRESS_LENGTH = 56;
    private static BaseEncoding base32Encoding = BaseEncoding.base32().upperCase().omitPadding();
    private static final byte[] b32Table = StrKey.decodingTable();

    StrKey() {
    }

    public static String encodeStellarAccountId(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.ACCOUNT_ID, data);
        return String.valueOf(encoded);
    }

    public static String encodeStellarAccountId(AccountID accountID) {
        char[] encoded = StrKey.encodeCheck(VersionByte.ACCOUNT_ID, accountID.getAccountID().getEd25519().getUint256());
        return String.valueOf(encoded);
    }

    public static AccountID muxedAccountToAccountId(MuxedAccount account) {
        AccountID aid = new AccountID();
        PublicKey key = new PublicKey();
        key.setDiscriminant(PublicKeyType.PUBLIC_KEY_TYPE_ED25519);
        if (account.getDiscriminant().equals(CryptoKeyType.KEY_TYPE_ED25519)) {
            key.setEd25519(account.getEd25519());
        } else if (account.getDiscriminant().equals(CryptoKeyType.KEY_TYPE_MUXED_ED25519)) {
            key.setEd25519(account.getMed25519().getEd25519());
        } else {
            throw new IllegalArgumentException("invalid muxed account type: " + account.getDiscriminant());
        }
        aid.setAccountID(key);
        return aid;
    }

    public static AccountID encodeToXDRAccountId(String data) {
        AccountID accountID = new AccountID();
        PublicKey publicKey = new PublicKey();
        publicKey.setDiscriminant(PublicKeyType.PUBLIC_KEY_TYPE_ED25519);
        try {
            publicKey.setEd25519(Uint256.decode(new XdrDataInputStream(new ByteArrayInputStream(StrKey.decodeStellarAccountId(data)))));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid address: " + data, e);
        }
        accountID.setAccountID(publicKey);
        return accountID;
    }

    public static MuxedAccount encodeToXDRMuxedAccount(String data) {
        if (data.length() == 56) {
            MuxedAccount accountID = new MuxedAccount();
            accountID.setDiscriminant(CryptoKeyType.KEY_TYPE_ED25519);
            try {
                accountID.setEd25519(Uint256.decode(new XdrDataInputStream(new ByteArrayInputStream(StrKey.decodeStellarAccountId(data)))));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("invalid address: " + data, e);
            }
            return accountID;
        }
        throw new IllegalArgumentException("invalid address length: " + data);
    }

    public static VersionByte decodeVersionByte(String data) {
        byte[] decoded = base32Encoding.decode(CharBuffer.wrap(data.toCharArray()));
        byte decodedVersionByte = decoded[0];
        Optional<VersionByte> versionByteOptional = VersionByte.findByValue(decodedVersionByte);
        if (!versionByteOptional.isPresent()) {
            throw new FormatException("Version byte is invalid");
        }
        return versionByteOptional.get();
    }

    public static byte[] decodeStellarAccountId(String data) {
        return StrKey.decodeCheck(VersionByte.ACCOUNT_ID, data.toCharArray());
    }

    public static char[] encodeStellarSecretSeed(byte[] data) {
        return StrKey.encodeCheck(VersionByte.SEED, data);
    }

    public static byte[] decodeStellarSecretSeed(char[] data) {
        return StrKey.decodeCheck(VersionByte.SEED, data);
    }

    public static String encodePreAuthTx(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.PRE_AUTH_TX, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodePreAuthTx(String data) {
        return StrKey.decodeCheck(VersionByte.PRE_AUTH_TX, data.toCharArray());
    }

    public static String encodeSha256Hash(byte[] data) {
        char[] encoded = StrKey.encodeCheck(VersionByte.SHA256_HASH, data);
        return String.valueOf(encoded);
    }

    public static byte[] decodeSha256Hash(String data) {
        return StrKey.decodeCheck(VersionByte.SHA256_HASH, data.toCharArray());
    }

    protected static char[] encodeCheck(VersionByte versionByte, byte[] data) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(versionByte.getValue());
            outputStream.write(data);
            byte[] payload = outputStream.toByteArray();
            byte[] checksum = StrKey.calculateChecksum(payload);
            outputStream.write(checksum);
            byte[] unencoded = outputStream.toByteArray();
            if (VersionByte.SEED != versionByte) {
                return base32Encoding.encode(unencoded).toCharArray();
            }
            CharArrayWriter charArrayWriter = new CharArrayWriter(unencoded.length);
            OutputStream charOutputStream = base32Encoding.encodingStream(charArrayWriter);
            charOutputStream.write(unencoded);
            char[] charsEncoded = charArrayWriter.toCharArray();
            Arrays.fill(unencoded, (byte)0);
            Arrays.fill(payload, (byte)0);
            Arrays.fill(checksum, (byte)0);
            int bufferSize = charArrayWriter.size();
            char[] zeros = new char[bufferSize];
            Arrays.fill(zeros, '0');
            charArrayWriter.reset();
            charArrayWriter.write(zeros);
            return charsEncoded;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected static byte[] decodeCheck(VersionByte versionByte, char[] encoded) {
        byte leftoverBitsMask;
        byte lastChar;
        byte decodedLastChar;
        byte[] bytes = new byte[encoded.length];
        for (int i = 0; i < encoded.length; ++i) {
            bytes[i] = (byte)encoded[i];
        }
        if (bytes.length < 5) {
            throw new IllegalArgumentException("Encoded char array must have a length of at least 5.");
        }
        int leftoverBits = bytes.length * 5 % 8;
        if (leftoverBits >= 5) {
            throw new IllegalArgumentException("Encoded char array has leftover character.");
        }
        if (leftoverBits > 0 && ((decodedLastChar = b32Table[lastChar = bytes[bytes.length - 1]]) & (leftoverBitsMask = (byte)(15 >> 4 - leftoverBits))) != 0) {
            throw new IllegalArgumentException("Unused bits should be set to 0.");
        }
        byte[] decoded = base32Encoding.decode(CharBuffer.wrap(encoded));
        byte decodedVersionByte = decoded[0];
        byte[] payload = Arrays.copyOfRange(decoded, 0, decoded.length - 2);
        byte[] data = Arrays.copyOfRange(payload, 1, payload.length);
        byte[] checksum = Arrays.copyOfRange(decoded, decoded.length - 2, decoded.length);
        if (decodedVersionByte != versionByte.getValue()) {
            throw new FormatException("Version byte is invalid");
        }
        byte[] expectedChecksum = StrKey.calculateChecksum(payload);
        if (!Arrays.equals(expectedChecksum, checksum)) {
            throw new FormatException("Checksum invalid");
        }
        if (VersionByte.SEED.getValue() == decodedVersionByte) {
            Arrays.fill(bytes, (byte)0);
            Arrays.fill(decoded, (byte)0);
            Arrays.fill(payload, (byte)0);
        }
        return data;
    }

    protected static byte[] calculateChecksum(byte[] bytes) {
        int crc = 0;
        int i = 0;
        for (int count = bytes.length; count > 0; --count) {
            int code = crc >>> 8 & 0xFF;
            code ^= bytes[i++] & 0xFF;
            code ^= code >>> 4;
            crc = crc << 8 & 0xFFFF;
            crc ^= code;
            code = code << 5 & 0xFFFF;
            crc ^= code;
            code = code << 7 & 0xFFFF;
            crc ^= code;
        }
        return new byte[]{(byte)crc, (byte)(crc >>> 8)};
    }

    private static byte[] decodingTable() {
        byte[] table = new byte[256];
        for (int i = 0; i < 256; ++i) {
            table[i] = -1;
        }
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
        for (int i = 0; i < alphabet.length(); ++i) {
            table[alphabet.charAt((int)i)] = (byte)i;
        }
        return table;
    }

    public static enum VersionByte {
        ACCOUNT_ID(48),
        SEED(-112),
        PRE_AUTH_TX(-104),
        SHA256_HASH(-72);

        private final byte value;

        private VersionByte(byte value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Optional<VersionByte> findByValue(byte value) {
            for (VersionByte versionByte : VersionByte.values()) {
                if (value != versionByte.value) continue;
                return Optional.of(versionByte);
            }
            return Optional.absent();
        }
    }
}

