/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.SetOptionsOp;
import org.stellar.sdk.xdr.Signer;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.String32;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrString;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class SetOptionsOperation
extends Operation {
    private final String inflationDestination;
    private final Integer clearFlags;
    private final Integer setFlags;
    private final Integer masterKeyWeight;
    private final Integer lowThreshold;
    private final Integer mediumThreshold;
    private final Integer highThreshold;
    private final String homeDomain;
    private final SignerKey signer;
    private final Integer signerWeight;

    private SetOptionsOperation(String inflationDestination, Integer clearFlags, Integer setFlags, Integer masterKeyWeight, Integer lowThreshold, Integer mediumThreshold, Integer highThreshold, String homeDomain, SignerKey signer, Integer signerWeight) {
        this.inflationDestination = inflationDestination;
        this.clearFlags = clearFlags;
        this.setFlags = setFlags;
        this.masterKeyWeight = masterKeyWeight;
        this.lowThreshold = lowThreshold;
        this.mediumThreshold = mediumThreshold;
        this.highThreshold = highThreshold;
        this.homeDomain = homeDomain;
        this.signer = signer;
        this.signerWeight = signerWeight;
        if (this.homeDomain != null && new XdrString(this.homeDomain).getBytes().length > 32) {
            throw new IllegalArgumentException("home domain cannot exceed 32 bytes");
        }
    }

    public String getInflationDestination() {
        return this.inflationDestination;
    }

    public Integer getClearFlags() {
        return this.clearFlags;
    }

    public Integer getSetFlags() {
        return this.setFlags;
    }

    public Integer getMasterKeyWeight() {
        return this.masterKeyWeight;
    }

    public Integer getLowThreshold() {
        return this.lowThreshold;
    }

    public Integer getMediumThreshold() {
        return this.mediumThreshold;
    }

    public Integer getHighThreshold() {
        return this.highThreshold;
    }

    public String getHomeDomain() {
        return this.homeDomain;
    }

    public SignerKey getSigner() {
        return this.signer;
    }

    public Integer getSignerWeight() {
        return this.signerWeight;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        Uint32 uint32;
        SetOptionsOp op = new SetOptionsOp();
        if (this.inflationDestination != null) {
            op.setInflationDest(StrKey.encodeToXDRAccountId(this.inflationDestination));
        }
        if (this.clearFlags != null) {
            Uint32 clearFlags = new Uint32();
            clearFlags.setUint32(this.clearFlags);
            op.setClearFlags(clearFlags);
        }
        if (this.setFlags != null) {
            Uint32 setFlags = new Uint32();
            setFlags.setUint32(this.setFlags);
            op.setSetFlags(setFlags);
        }
        if (this.masterKeyWeight != null) {
            uint32 = new Uint32();
            uint32.setUint32(this.masterKeyWeight);
            op.setMasterWeight(uint32);
        }
        if (this.lowThreshold != null) {
            uint32 = new Uint32();
            uint32.setUint32(this.lowThreshold);
            op.setLowThreshold(uint32);
        }
        if (this.mediumThreshold != null) {
            uint32 = new Uint32();
            uint32.setUint32(this.mediumThreshold);
            op.setMedThreshold(uint32);
        }
        if (this.highThreshold != null) {
            uint32 = new Uint32();
            uint32.setUint32(this.highThreshold);
            op.setHighThreshold(uint32);
        }
        if (this.homeDomain != null) {
            String32 homeDomain = new String32();
            homeDomain.setString32(new XdrString(this.homeDomain));
            op.setHomeDomain(homeDomain);
        }
        if (this.signer != null) {
            Signer signer = new Signer();
            Uint32 weight = new Uint32();
            weight.setUint32(this.signerWeight & 0xFF);
            signer.setKey(this.signer);
            signer.setWeight(weight);
            op.setSigner(signer);
        }
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.SET_OPTIONS);
        body.setSetOptionsOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceAccount(), this.inflationDestination, this.clearFlags, this.setFlags, this.masterKeyWeight, this.lowThreshold, this.mediumThreshold, this.highThreshold, this.homeDomain, this.signer, this.signerWeight);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SetOptionsOperation)) {
            return false;
        }
        SetOptionsOperation other = (SetOptionsOperation)object;
        return Objects.equal(this.getSourceAccount(), other.getSourceAccount()) && Objects.equal(this.inflationDestination, other.inflationDestination) && Objects.equal(this.clearFlags, other.clearFlags) && Objects.equal(this.setFlags, other.setFlags) && Objects.equal(this.masterKeyWeight, other.masterKeyWeight) && Objects.equal(this.lowThreshold, other.lowThreshold) && Objects.equal(this.mediumThreshold, other.mediumThreshold) && Objects.equal(this.highThreshold, other.highThreshold) && Objects.equal(this.homeDomain, other.homeDomain) && Objects.equal(this.signer, other.signer) && Objects.equal(this.signerWeight, other.signerWeight);
    }

    public static class Builder {
        private String inflationDestination;
        private Integer clearFlags;
        private Integer setFlags;
        private Integer masterKeyWeight;
        private Integer lowThreshold;
        private Integer mediumThreshold;
        private Integer highThreshold;
        private String homeDomain;
        private SignerKey signer;
        private Integer signerWeight;
        private String sourceAccount;

        Builder(SetOptionsOp op) {
            if (op.getInflationDest() != null) {
                this.inflationDestination = StrKey.encodeStellarAccountId(op.getInflationDest());
            }
            if (op.getClearFlags() != null) {
                this.clearFlags = op.getClearFlags().getUint32();
            }
            if (op.getSetFlags() != null) {
                this.setFlags = op.getSetFlags().getUint32();
            }
            if (op.getMasterWeight() != null) {
                this.masterKeyWeight = (int)op.getMasterWeight().getUint32();
            }
            if (op.getLowThreshold() != null) {
                this.lowThreshold = (int)op.getLowThreshold().getUint32();
            }
            if (op.getMedThreshold() != null) {
                this.mediumThreshold = (int)op.getMedThreshold().getUint32();
            }
            if (op.getHighThreshold() != null) {
                this.highThreshold = (int)op.getHighThreshold().getUint32();
            }
            if (op.getHomeDomain() != null) {
                this.homeDomain = op.getHomeDomain().getString32().toString();
            }
            if (op.getSigner() != null) {
                this.signer = op.getSigner().getKey();
                this.signerWeight = op.getSigner().getWeight().getUint32() & 0xFF;
            }
        }

        public Builder() {
        }

        public Builder setInflationDestination(String inflationDestination) {
            this.inflationDestination = inflationDestination;
            return this;
        }

        public Builder setClearFlags(int clearFlags) {
            this.clearFlags = clearFlags;
            return this;
        }

        public Builder setSetFlags(int setFlags) {
            this.setFlags = setFlags;
            return this;
        }

        public Builder setMasterKeyWeight(int masterKeyWeight) {
            this.masterKeyWeight = masterKeyWeight;
            return this;
        }

        public Builder setLowThreshold(int lowThreshold) {
            this.lowThreshold = lowThreshold;
            return this;
        }

        public Builder setMediumThreshold(int mediumThreshold) {
            this.mediumThreshold = mediumThreshold;
            return this;
        }

        public Builder setHighThreshold(int highThreshold) {
            this.highThreshold = highThreshold;
            return this;
        }

        public Builder setHomeDomain(String homeDomain) {
            if (homeDomain.length() > 32) {
                throw new IllegalArgumentException("Home domain must be <= 32 characters");
            }
            this.homeDomain = homeDomain;
            return this;
        }

        public Builder setSigner(SignerKey signer, Integer weight) {
            Preconditions.checkNotNull(signer, "signer cannot be null");
            Preconditions.checkNotNull(weight, "weight cannot be null");
            this.signer = signer;
            this.signerWeight = weight & 0xFF;
            return this;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public SetOptionsOperation build() {
            SetOptionsOperation operation = new SetOptionsOperation(this.inflationDestination, this.clearFlags, this.setFlags, this.masterKeyWeight, this.lowThreshold, this.mediumThreshold, this.highThreshold, this.homeDomain, this.signer, this.signerWeight);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

