/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.Account;
import org.stellar.sdk.InvalidSep10ChallengeException;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.ManageDataOperation;
import org.stellar.sdk.Network;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SignatureHint;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.collect.HashMultimap;
import shadow.com.google.common.io.BaseEncoding;

public class Sep10Challenge {
    private static final String MANAGER_DATA_NAME_FLAG = "auth";

    public static Transaction newChallenge(KeyPair signer, Network network, String clientAccountId, String domainName, TimeBounds timebounds) throws InvalidSep10ChallengeException {
        byte[] nonce = new byte[48];
        SecureRandom random = new SecureRandom();
        random.nextBytes(nonce);
        BaseEncoding base64Encoding = BaseEncoding.base64();
        byte[] encodedNonce = base64Encoding.encode(nonce).getBytes();
        if (StrKey.decodeVersionByte(clientAccountId) != StrKey.VersionByte.ACCOUNT_ID) {
            throw new InvalidSep10ChallengeException(clientAccountId + " is not a valid account id");
        }
        Account sourceAccount = new Account(signer.getAccountId(), -1L);
        ManageDataOperation operation = new ManageDataOperation.Builder(String.format("%s %s", domainName, MANAGER_DATA_NAME_FLAG), encodedNonce).setSourceAccount(clientAccountId).build();
        Transaction transaction = new Transaction.Builder(sourceAccount, network).addTimeBounds(timebounds).setBaseFee(100).addOperation(operation).build();
        transaction.sign(signer);
        return transaction;
    }

    public static ChallengeTransaction readChallengeTransaction(String challengeXdr, String serverAccountId, Network network, String[] domainNames) throws InvalidSep10ChallengeException, IOException {
        byte[] nonce;
        if (domainNames == null || domainNames.length == 0) {
            throw new IllegalArgumentException("At least one domain name must be included in domainNames.");
        }
        AbstractTransaction parsed = Transaction.fromEnvelopeXdr(challengeXdr, network);
        if (!(parsed instanceof Transaction)) {
            throw new InvalidSep10ChallengeException("Transaction cannot be a fee bump transaction");
        }
        Transaction transaction = (Transaction)parsed;
        if (StrKey.decodeVersionByte(serverAccountId) != StrKey.VersionByte.ACCOUNT_ID) {
            throw new InvalidSep10ChallengeException("serverAccountId: " + serverAccountId + " is not a valid account id");
        }
        if (!serverAccountId.equals(transaction.getSourceAccount())) {
            throw new InvalidSep10ChallengeException("Transaction source account is not equal to server's account.");
        }
        if (transaction.getSequenceNumber() != 0L) {
            throw new InvalidSep10ChallengeException("The transaction sequence number should be zero.");
        }
        if (transaction.getTimeBounds() == null) {
            throw new InvalidSep10ChallengeException("Transaction requires timebounds.");
        }
        long maxTime = transaction.getTimeBounds().getMaxTime();
        long minTime = transaction.getTimeBounds().getMinTime();
        if (maxTime == 0L) {
            throw new InvalidSep10ChallengeException("Transaction requires non-infinite timebounds.");
        }
        long currentTime = System.currentTimeMillis() / 1000L;
        if (currentTime < minTime || currentTime > maxTime) {
            throw new InvalidSep10ChallengeException("Transaction is not within range of the specified timebounds.");
        }
        if (transaction.getOperations().length < 1) {
            throw new InvalidSep10ChallengeException("Transaction requires at least one ManageData operation.");
        }
        Operation operation = transaction.getOperations()[0];
        if (!(operation instanceof ManageDataOperation)) {
            throw new InvalidSep10ChallengeException("Operation type should be ManageData.");
        }
        ManageDataOperation manageDataOperation = (ManageDataOperation)operation;
        String clientAccountId = manageDataOperation.getSourceAccount();
        if (clientAccountId == null) {
            throw new InvalidSep10ChallengeException("Operation should have a source account.");
        }
        String matchedDomainName = null;
        for (String homeDomain : domainNames) {
            if (!(homeDomain + " " + MANAGER_DATA_NAME_FLAG).equals(manageDataOperation.getName())) continue;
            matchedDomainName = homeDomain;
            break;
        }
        if (matchedDomainName == null) {
            throw new InvalidSep10ChallengeException("The transaction's operation key name does not include one of the expected home domains.");
        }
        if (StrKey.decodeVersionByte(clientAccountId) != StrKey.VersionByte.ACCOUNT_ID) {
            throw new InvalidSep10ChallengeException("clientAccountId: " + clientAccountId + " is not a valid account id");
        }
        if (manageDataOperation.getValue() == null) {
            throw new InvalidSep10ChallengeException("The transaction's operation value should not be null.");
        }
        if (manageDataOperation.getValue().length != 64) {
            throw new InvalidSep10ChallengeException("Random nonce encoded as base64 should be 64 bytes long.");
        }
        BaseEncoding base64Encoding = BaseEncoding.base64();
        try {
            nonce = base64Encoding.decode(new String(manageDataOperation.getValue()));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSep10ChallengeException("Failed to decode random nonce provided in ManageData operation.", e);
        }
        if (nonce.length != 48) {
            throw new InvalidSep10ChallengeException("Random nonce before encoding as base64 should be 48 bytes long.");
        }
        for (int i = 1; i < transaction.getOperations().length; ++i) {
            Operation op = transaction.getOperations()[i];
            if (!(op instanceof ManageDataOperation)) {
                throw new InvalidSep10ChallengeException("Operation type should be ManageData.");
            }
            ManageDataOperation manageDataOp = (ManageDataOperation)op;
            if (manageDataOp.getSourceAccount() == null) {
                throw new InvalidSep10ChallengeException("Operation should have a source account.");
            }
            if (manageDataOp.getSourceAccount().equals(serverAccountId)) continue;
            throw new InvalidSep10ChallengeException("Subsequent operations are unrecognized.");
        }
        if (!Sep10Challenge.verifyTransactionSignature(transaction, serverAccountId)) {
            throw new InvalidSep10ChallengeException(String.format("Transaction not signed by server: %s.", serverAccountId));
        }
        return new ChallengeTransaction(transaction, clientAccountId, matchedDomainName);
    }

    public static ChallengeTransaction readChallengeTransaction(String challengeXdr, String serverAccountId, Network network, String domainName) throws InvalidSep10ChallengeException, IOException {
        return Sep10Challenge.readChallengeTransaction(challengeXdr, serverAccountId, network, new String[]{domainName});
    }

    public static Set<String> verifyChallengeTransactionSigners(String challengeXdr, String serverAccountId, Network network, String domainName, Set<String> signers) throws InvalidSep10ChallengeException, IOException {
        return Sep10Challenge.verifyChallengeTransactionSigners(challengeXdr, serverAccountId, network, new String[]{domainName}, signers);
    }

    public static Set<String> verifyChallengeTransactionSigners(String challengeXdr, String serverAccountId, Network network, String[] domainNames, Set<String> signers) throws InvalidSep10ChallengeException, IOException {
        if (signers == null || signers.isEmpty()) {
            throw new InvalidSep10ChallengeException("No verifiable signers provided, at least one G... address must be provided.");
        }
        ChallengeTransaction parsedChallengeTransaction = Sep10Challenge.readChallengeTransaction(challengeXdr, serverAccountId, network, domainNames);
        Transaction transaction = parsedChallengeTransaction.getTransaction();
        KeyPair serverKeyPair = KeyPair.fromAccountId(serverAccountId);
        HashSet<String> clientSigners = new HashSet<String>();
        for (String signer : signers) {
            StrKey.VersionByte versionByte;
            try {
                versionByte = StrKey.decodeVersionByte(signer);
            }
            catch (Exception e) {
                continue;
            }
            if (!StrKey.VersionByte.ACCOUNT_ID.equals((Object)versionByte) || serverKeyPair.getAccountId().equals(signer)) continue;
            clientSigners.add(signer);
        }
        if (clientSigners.isEmpty()) {
            throw new InvalidSep10ChallengeException("No verifiable signers provided, at least one G... address must be provided.");
        }
        HashSet<String> allSigners = new HashSet<String>(clientSigners);
        allSigners.add(serverKeyPair.getAccountId());
        Set<String> signersFound = Sep10Challenge.verifyTransactionSignatures(transaction, allSigners);
        boolean serverSignerFound = signersFound.remove(serverKeyPair.getAccountId());
        if (!serverSignerFound) {
            throw new InvalidSep10ChallengeException(String.format("Transaction not signed by server: %s.", serverAccountId));
        }
        if (signersFound.isEmpty()) {
            throw new InvalidSep10ChallengeException("Transaction not signed by any client signer.");
        }
        if (signersFound.size() != transaction.getSignatures().size() - 1) {
            throw new InvalidSep10ChallengeException("Transaction has unrecognized signatures.");
        }
        return signersFound;
    }

    public static Set<String> verifyChallengeTransactionThreshold(String challengeXdr, String serverAccountId, Network network, String[] domainNames, int threshold, Set<Signer> signers) throws InvalidSep10ChallengeException, IOException {
        if (signers == null || signers.isEmpty()) {
            throw new InvalidSep10ChallengeException("No verifiable signers provided, at least one G... address must be provided.");
        }
        HashMap<String, Integer> weightsForSigner = new HashMap<String, Integer>();
        for (Signer signer : signers) {
            weightsForSigner.put(signer.getKey(), signer.getWeight());
        }
        Set<String> signersFound = Sep10Challenge.verifyChallengeTransactionSigners(challengeXdr, serverAccountId, network, domainNames, weightsForSigner.keySet());
        int sum = 0;
        for (String signer : signersFound) {
            Integer weight = (Integer)weightsForSigner.get(signer);
            if (weight == null) continue;
            sum += weight.intValue();
        }
        if (sum < threshold) {
            throw new InvalidSep10ChallengeException(String.format("Signers with weight %d do not meet threshold %d.", sum, threshold));
        }
        return signersFound;
    }

    public static Set<String> verifyChallengeTransactionThreshold(String challengeXdr, String serverAccountId, Network network, String domainName, int threshold, Set<Signer> signers) throws InvalidSep10ChallengeException, IOException {
        return Sep10Challenge.verifyChallengeTransactionThreshold(challengeXdr, serverAccountId, network, new String[]{domainName}, threshold, signers);
    }

    private static Set<String> verifyTransactionSignatures(Transaction transaction, Set<String> signers) throws InvalidSep10ChallengeException {
        if (transaction.getSignatures().isEmpty()) {
            throw new InvalidSep10ChallengeException("Transaction has no signatures.");
        }
        byte[] txHash = transaction.hash();
        HashSet<String> signersFound = new HashSet<String>();
        HashMultimap<SignatureHint, Signature> signatures = HashMultimap.create();
        for (DecoratedSignature decoratedSignature : transaction.getSignatures()) {
            signatures.put(decoratedSignature.getHint(), decoratedSignature.getSignature());
        }
        block1: for (String signer : signers) {
            KeyPair keyPair = KeyPair.fromAccountId(signer);
            SignatureHint hint = keyPair.getSignatureHint();
            for (Signature signature : signatures.get(hint)) {
                if (!keyPair.verify(txHash, signature.getSignature())) continue;
                signersFound.add(signer);
                signatures.remove(hint, signature);
                continue block1;
            }
        }
        return signersFound;
    }

    private static boolean verifyTransactionSignature(Transaction transaction, String accountId) throws InvalidSep10ChallengeException {
        return !Sep10Challenge.verifyTransactionSignatures(transaction, Collections.singleton(accountId)).isEmpty();
    }

    public static class Signer {
        private final String key;
        private final int weight;

        public Signer(String key, int weight) {
            this.key = key;
            this.weight = weight;
        }

        public String getKey() {
            return this.key;
        }

        public int getWeight() {
            return this.weight;
        }

        public int hashCode() {
            return Objects.hashCode(this.key, this.weight);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Signer)) {
                return false;
            }
            Signer other = (Signer)object;
            return Objects.equal(this.key, other.key) && Objects.equal(this.weight, other.weight);
        }
    }

    public static class ChallengeTransaction {
        private final Transaction transaction;
        private final String clientAccountId;
        private final String matchedHomeDomain;

        public ChallengeTransaction(Transaction transaction, String clientAccountId, String matchedHomeDomain) {
            this.transaction = transaction;
            this.clientAccountId = clientAccountId;
            this.matchedHomeDomain = matchedHomeDomain;
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public String getClientAccountId() {
            return this.clientAccountId;
        }

        public String getMatchedHomeDomain() {
            return this.matchedHomeDomain;
        }

        public int hashCode() {
            return Objects.hashCode(this.transaction.hashHex(), this.clientAccountId);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ChallengeTransaction)) {
                return false;
            }
            ChallengeTransaction other = (ChallengeTransaction)object;
            return Objects.equal(this.transaction.hashHex(), other.transaction.hashHex()) && Objects.equal(this.clientAccountId, other.clientAccountId) && Objects.equal(this.matchedHomeDomain, other.matchedHomeDomain);
        }
    }
}

