/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class RevokeTrustlineSponsorshipOperation
extends Operation {
    private final String accountId;
    private final Asset asset;

    private RevokeTrustlineSponsorshipOperation(String accountId, Asset asset) {
        this.accountId = accountId;
        this.asset = asset;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Asset getAsset() {
        return this.asset;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        LedgerKey.LedgerKeyTrustLine trustLine = new LedgerKey.LedgerKeyTrustLine();
        trustLine.setAccountID(StrKey.encodeToXDRAccountId(this.accountId));
        trustLine.setAsset(this.asset.toXdr());
        key.setTrustLine(trustLine);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.accountId, this.asset, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RevokeTrustlineSponsorshipOperation)) {
            return false;
        }
        RevokeTrustlineSponsorshipOperation other = (RevokeTrustlineSponsorshipOperation)object;
        return Objects.equal(this.accountId, other.accountId) && Objects.equal(this.asset, other.asset) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String accountId;
        private final Asset asset;
        private String mSourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.accountId = StrKey.encodeStellarAccountId(op.getLedgerKey().getTrustLine().getAccountID());
            this.asset = Asset.fromXdr(op.getLedgerKey().getTrustLine().getAsset());
        }

        public Builder(String accountId, Asset asset) {
            this.accountId = accountId;
            this.asset = asset;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public RevokeTrustlineSponsorshipOperation build() {
            RevokeTrustlineSponsorshipOperation operation = new RevokeTrustlineSponsorshipOperation(this.accountId, this.asset);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

