/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import org.stellar.sdk.xdr.SignerKey;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class RevokeSignerSponsorshipOperation
extends Operation {
    private final String accountId;
    private final SignerKey signer;

    private RevokeSignerSponsorshipOperation(String accountId, SignerKey signer) {
        this.accountId = accountId;
        this.signer = signer;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public SignerKey getSigner() {
        return this.signer;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        RevokeSponsorshipOp.RevokeSponsorshipOpSigner xdrSigner = new RevokeSponsorshipOp.RevokeSponsorshipOpSigner();
        xdrSigner.setAccountID(StrKey.encodeToXDRAccountId(this.accountId));
        xdrSigner.setSignerKey(this.signer);
        op.setSigner(xdrSigner);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_SIGNER);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.accountId, this.signer, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RevokeSignerSponsorshipOperation)) {
            return false;
        }
        RevokeSignerSponsorshipOperation other = (RevokeSignerSponsorshipOperation)object;
        return Objects.equal(this.accountId, other.accountId) && Objects.equal(this.signer, other.signer) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String accountId;
        private final SignerKey signer;
        private String mSourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.accountId = StrKey.encodeStellarAccountId(op.getSigner().getAccountID());
            this.signer = op.getSigner().getSignerKey();
        }

        public Builder(String accountId, SignerKey signer) {
            this.accountId = accountId;
            this.signer = signer;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public RevokeSignerSponsorshipOperation build() {
            RevokeSignerSponsorshipOperation operation = new RevokeSignerSponsorshipOperation(this.accountId, this.signer);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

