/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class RevokeOfferSponsorshipOperation
extends Operation {
    private final Long offerId;

    private RevokeOfferSponsorshipOperation(Long offerId) {
        this.offerId = offerId;
    }

    public Long getOfferId() {
        return this.offerId;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        LedgerKey.LedgerKeyOffer offer = new LedgerKey.LedgerKeyOffer();
        Int64 id = new Int64();
        id.setInt64(this.offerId);
        offer.setOfferID(id);
        key.setOffer(offer);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.offerId, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RevokeOfferSponsorshipOperation)) {
            return false;
        }
        RevokeOfferSponsorshipOperation other = (RevokeOfferSponsorshipOperation)object;
        return Objects.equal(this.offerId, other.offerId) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final Long offerId;
        private String mSourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.offerId = op.getLedgerKey().getOffer().getOfferID().getInt64();
        }

        public Builder(Long offerId) {
            this.offerId = offerId;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public RevokeOfferSponsorshipOperation build() {
            RevokeOfferSponsorshipOperation operation = new RevokeOfferSponsorshipOperation(this.offerId);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

