/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.XdrString;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class RevokeDataSponsorshipOperation
extends Operation {
    private final String accountId;
    private final String dataName;

    private RevokeDataSponsorshipOperation(String accountId, String dataName) {
        this.accountId = accountId;
        this.dataName = dataName;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getDataName() {
        return this.dataName;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        LedgerKey.LedgerKeyData data = new LedgerKey.LedgerKeyData();
        data.setAccountID(StrKey.encodeToXDRAccountId(this.accountId));
        String64 dn = new String64();
        dn.setString64(new XdrString(this.dataName));
        data.setDataName(dn);
        key.setData(data);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.accountId, this.dataName, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RevokeDataSponsorshipOperation)) {
            return false;
        }
        RevokeDataSponsorshipOperation other = (RevokeDataSponsorshipOperation)object;
        return Objects.equal(this.accountId, other.accountId) && Objects.equal(this.dataName, other.dataName) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String accountId;
        private final String dataName;
        private String mSourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.accountId = StrKey.encodeStellarAccountId(op.getLedgerKey().getData().getAccountID());
            this.dataName = op.getLedgerKey().getData().getDataName().getString64().toString();
        }

        public Builder(String accountId, String dataName) {
            this.accountId = accountId;
            this.dataName = dataName;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public RevokeDataSponsorshipOperation build() {
            RevokeDataSponsorshipOperation operation = new RevokeDataSponsorshipOperation(this.accountId, this.dataName);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

