/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.ClaimableBalanceIDType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.io.BaseEncoding;

public class RevokeClaimableBalanceSponsorshipOperation
extends Operation {
    private final String balanceId;

    private RevokeClaimableBalanceSponsorshipOperation(String balanceId) {
        this.balanceId = balanceId;
    }

    public String getBalanceId() {
        return this.balanceId;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        LedgerKey.LedgerKeyClaimableBalance claimableBalance = new LedgerKey.LedgerKeyClaimableBalance();
        ClaimableBalanceID id = new ClaimableBalanceID();
        id.setDiscriminant(ClaimableBalanceIDType.CLAIMABLE_BALANCE_ID_TYPE_V0);
        Hash hash = new Hash();
        hash.setHash(BaseEncoding.base16().lowerCase().decode(this.balanceId.toLowerCase()));
        id.setV0(hash);
        claimableBalance.setBalanceID(id);
        key.setClaimableBalance(claimableBalance);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.balanceId, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RevokeClaimableBalanceSponsorshipOperation)) {
            return false;
        }
        RevokeClaimableBalanceSponsorshipOperation other = (RevokeClaimableBalanceSponsorshipOperation)object;
        return Objects.equal(this.balanceId, other.balanceId) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String balanceId;
        private String mSourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.balanceId = BaseEncoding.base16().lowerCase().encode(op.getLedgerKey().getClaimableBalance().getBalanceID().getV0().getHash());
        }

        public Builder(String balanceId) {
            this.balanceId = balanceId;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public RevokeClaimableBalanceSponsorshipOperation build() {
            RevokeClaimableBalanceSponsorshipOperation operation = new RevokeClaimableBalanceSponsorshipOperation(this.balanceId);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

