/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class RevokeAccountSponsorshipOperation
extends Operation {
    private final String accountId;

    private RevokeAccountSponsorshipOperation(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        LedgerKey.LedgerKeyAccount account = new LedgerKey.LedgerKeyAccount();
        account.setAccountID(StrKey.encodeToXDRAccountId(this.accountId));
        key.setAccount(account);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.accountId, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RevokeAccountSponsorshipOperation)) {
            return false;
        }
        RevokeAccountSponsorshipOperation other = (RevokeAccountSponsorshipOperation)object;
        return Objects.equal(this.accountId, other.accountId) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String accountId;
        private String mSourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.accountId = StrKey.encodeStellarAccountId(op.getLedgerKey().getAccount().getAccountID());
        }

        public Builder(String accountId) {
            this.accountId = accountId;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public RevokeAccountSponsorshipOperation build() {
            RevokeAccountSponsorshipOperation operation = new RevokeAccountSponsorshipOperation(this.accountId);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

