/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.ArrayList;
import java.util.List;
import org.stellar.sdk.xdr.ClaimPredicate;
import org.stellar.sdk.xdr.ClaimPredicateType;
import org.stellar.sdk.xdr.Int64;
import org.threeten.bp.Instant;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.collect.Lists;

public abstract class Predicate {
    private static List<Predicate> convertXDRPredicates(ClaimPredicate[] predicates) {
        ArrayList<Predicate> list = Lists.newArrayList();
        for (ClaimPredicate p : predicates) {
            list.add(Predicate.fromXdr(p));
        }
        return list;
    }

    public static Predicate fromXdr(ClaimPredicate xdr) {
        switch (xdr.getDiscriminant()) {
            case CLAIM_PREDICATE_UNCONDITIONAL: {
                return new Unconditional();
            }
            case CLAIM_PREDICATE_AND: {
                return new And(Predicate.convertXDRPredicates(xdr.getAndPredicates()));
            }
            case CLAIM_PREDICATE_OR: {
                return new Or(Predicate.convertXDRPredicates(xdr.getOrPredicates()));
            }
            case CLAIM_PREDICATE_NOT: {
                return new Not(Predicate.fromXdr(xdr.getNotPredicate()));
            }
            case CLAIM_PREDICATE_BEFORE_RELATIVE_TIME: {
                return new RelBefore(xdr.getRelBefore().getInt64());
            }
            case CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME: {
                return new AbsBefore(xdr.getAbsBefore().getInt64());
            }
        }
        throw new IllegalArgumentException("Unknown asset type " + xdr.getDiscriminant());
    }

    public abstract boolean equals(Object var1);

    public abstract ClaimPredicate toXdr();

    public static class RelBefore
    extends Predicate {
        private final long secondsSinceClose;

        public RelBefore(long secondsSinceClose) {
            this.secondsSinceClose = secondsSinceClose;
        }

        public long getSecondsSinceClose() {
            return this.secondsSinceClose;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return this.getClass() == o.getClass() && Objects.equal(this.secondsSinceClose, ((RelBefore)o).secondsSinceClose);
        }

        public int hashCode() {
            return Objects.hashCode(this.secondsSinceClose);
        }

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_BEFORE_RELATIVE_TIME);
            Int64 t = new Int64();
            t.setInt64(this.secondsSinceClose);
            xdr.setRelBefore(t);
            return xdr;
        }
    }

    public static class AbsBefore
    extends Predicate {
        private final long epochSeconds;

        public AbsBefore(long epochSeconds) {
            this.epochSeconds = epochSeconds;
        }

        public long getTimestampSeconds() {
            return this.epochSeconds;
        }

        public Instant getDate() {
            return Instant.ofEpochSecond(this.epochSeconds);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return this.getClass() == o.getClass() && Objects.equal(this.epochSeconds, ((AbsBefore)o).epochSeconds);
        }

        public int hashCode() {
            return Objects.hashCode(this.epochSeconds);
        }

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME);
            Int64 t = new Int64();
            t.setInt64(this.epochSeconds);
            xdr.setAbsBefore(t);
            return xdr;
        }
    }

    public static class And
    extends Predicate {
        private final List<Predicate> inner;

        public And(List<Predicate> inner) {
            this.inner = inner;
        }

        public List<Predicate> getInner() {
            return this.inner;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return this.getClass() == o.getClass() && Objects.equal(this.inner, ((And)o).inner);
        }

        public int hashCode() {
            return Objects.hashCode(this.inner);
        }

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_AND);
            ClaimPredicate[] xdrInner = new ClaimPredicate[this.inner.size()];
            for (int i = 0; i < this.inner.size(); ++i) {
                xdrInner[i] = this.inner.get(i).toXdr();
            }
            xdr.setAndPredicates(xdrInner);
            return xdr;
        }
    }

    public static class Or
    extends Predicate {
        private final List<Predicate> inner;

        public Or(List<Predicate> inner) {
            this.inner = inner;
        }

        public List<Predicate> getInner() {
            return this.inner;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return this.getClass() == o.getClass() && Objects.equal(this.inner, ((Or)o).inner);
        }

        public int hashCode() {
            return Objects.hashCode(this.inner);
        }

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_OR);
            ClaimPredicate[] xdrInner = new ClaimPredicate[this.inner.size()];
            for (int i = 0; i < this.inner.size(); ++i) {
                xdrInner[i] = this.inner.get(i).toXdr();
            }
            xdr.setOrPredicates(xdrInner);
            return xdr;
        }
    }

    public static class Not
    extends Predicate {
        private final Predicate inner;

        public Not(Predicate inner) {
            this.inner = inner;
        }

        public Predicate getInner() {
            return this.inner;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return this.getClass() == o.getClass() && Objects.equal(this.inner, ((Not)o).inner);
        }

        public int hashCode() {
            return Objects.hashCode(this.inner);
        }

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_NOT);
            xdr.setNotPredicate(this.inner.toXdr());
            return xdr;
        }
    }

    public static class Unconditional
    extends Predicate {
        @Override
        public boolean equals(Object o) {
            return this == o || this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_UNCONDITIONAL);
            return xdr;
        }
    }
}

