/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Arrays;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictSendOp;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class PathPaymentStrictSendOperation
extends Operation {
    private final Asset sendAsset;
    private final String sendAmount;
    private final String destination;
    private final Asset destAsset;
    private final String destMin;
    private final Asset[] path;

    private PathPaymentStrictSendOperation(Asset sendAsset, String sendAmount, String destination, Asset destAsset, String destMin, Asset[] path) {
        this.sendAsset = Preconditions.checkNotNull(sendAsset, "sendAsset cannot be null");
        this.sendAmount = Preconditions.checkNotNull(sendAmount, "sendAmount cannot be null");
        this.destination = Preconditions.checkNotNull(destination, "destination cannot be null");
        this.destAsset = Preconditions.checkNotNull(destAsset, "destAsset cannot be null");
        this.destMin = Preconditions.checkNotNull(destMin, "destMin cannot be null");
        if (path == null) {
            this.path = new Asset[0];
        } else {
            Preconditions.checkArgument(path.length <= 5, "The maximum number of assets in the path is 5");
            this.path = path;
        }
    }

    public Asset getSendAsset() {
        return this.sendAsset;
    }

    public String getSendAmount() {
        return this.sendAmount;
    }

    public String getDestination() {
        return this.destination;
    }

    public Asset getDestAsset() {
        return this.destAsset;
    }

    public String getDestMin() {
        return this.destMin;
    }

    public Asset[] getPath() {
        return this.path;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        PathPaymentStrictSendOp op = new PathPaymentStrictSendOp();
        op.setSendAsset(this.sendAsset.toXdr());
        Int64 sendAmount = new Int64();
        sendAmount.setInt64(Operation.toXdrAmount(this.sendAmount));
        op.setSendAmount(sendAmount);
        op.setDestination(StrKey.encodeToXDRMuxedAccount(this.destination));
        op.setDestAsset(this.destAsset.toXdr());
        Int64 destMin = new Int64();
        destMin.setInt64(Operation.toXdrAmount(this.destMin));
        op.setDestMin(destMin);
        org.stellar.sdk.xdr.Asset[] path = new org.stellar.sdk.xdr.Asset[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            path[i] = this.path[i].toXdr();
        }
        op.setPath(path);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.PATH_PAYMENT_STRICT_SEND);
        body.setPathPaymentStrictSendOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceAccount(), this.destMin, this.destAsset, this.destination, Arrays.hashCode(this.path), this.sendAsset, this.sendAmount);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PathPaymentStrictSendOperation)) {
            return false;
        }
        PathPaymentStrictSendOperation other = (PathPaymentStrictSendOperation)object;
        return Objects.equal(this.getSourceAccount(), other.getSourceAccount()) && Objects.equal(this.destMin, other.destMin) && Objects.equal(this.destAsset, other.destAsset) && Objects.equal(this.destination, other.destination) && Arrays.equals(this.path, other.path) && Objects.equal(this.sendAsset, other.sendAsset) && Objects.equal(this.sendAmount, other.sendAmount);
    }

    public static class Builder {
        private final Asset sendAsset;
        private final String sendAmount;
        private final String destination;
        private final Asset destAsset;
        private final String destMin;
        private Asset[] path;
        private String mSourceAccount;

        Builder(PathPaymentStrictSendOp op) {
            this.sendAsset = Asset.fromXdr(op.getSendAsset());
            this.sendAmount = Operation.fromXdrAmount(op.getSendAmount().getInt64());
            this.destination = StrKey.encodeStellarAccountId(StrKey.muxedAccountToAccountId(op.getDestination()));
            this.destAsset = Asset.fromXdr(op.getDestAsset());
            this.destMin = Operation.fromXdrAmount(op.getDestMin().getInt64());
            this.path = new Asset[op.getPath().length];
            for (int i = 0; i < op.getPath().length; ++i) {
                this.path[i] = Asset.fromXdr(op.getPath()[i]);
            }
        }

        public Builder(Asset sendAsset, String sendAmount, String destination, Asset destAsset, String destMin) {
            this.sendAsset = Preconditions.checkNotNull(sendAsset, "sendAsset cannot be null");
            this.sendAmount = Preconditions.checkNotNull(sendAmount, "sendAmount cannot be null");
            this.destination = Preconditions.checkNotNull(destination, "destination cannot be null");
            this.destAsset = Preconditions.checkNotNull(destAsset, "destAsset cannot be null");
            this.destMin = Preconditions.checkNotNull(destMin, "destMin cannot be null");
        }

        public Builder setPath(Asset[] path) {
            Preconditions.checkNotNull(path, "path cannot be null");
            Preconditions.checkArgument(path.length <= 5, "The maximum number of assets in the path is 5");
            this.path = path;
            return this;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public PathPaymentStrictSendOperation build() {
            PathPaymentStrictSendOperation operation = new PathPaymentStrictSendOperation(this.sendAsset, this.sendAmount, this.destination, this.destAsset, this.destMin, this.path);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

