/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Arrays;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictReceiveOp;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class PathPaymentStrictReceiveOperation
extends Operation {
    private final Asset sendAsset;
    private final String sendMax;
    private final String destination;
    private final Asset destAsset;
    private final String destAmount;
    private final Asset[] path;

    private PathPaymentStrictReceiveOperation(Asset sendAsset, String sendMax, String destination, Asset destAsset, String destAmount, Asset[] path) {
        this.sendAsset = Preconditions.checkNotNull(sendAsset, "sendAsset cannot be null");
        this.sendMax = Preconditions.checkNotNull(sendMax, "sendMax cannot be null");
        this.destination = Preconditions.checkNotNull(destination, "destination cannot be null");
        this.destAsset = Preconditions.checkNotNull(destAsset, "destAsset cannot be null");
        this.destAmount = Preconditions.checkNotNull(destAmount, "destAmount cannot be null");
        if (path == null) {
            this.path = new Asset[0];
        } else {
            Preconditions.checkArgument(path.length <= 5, "The maximum number of assets in the path is 5");
            this.path = path;
        }
    }

    public Asset getSendAsset() {
        return this.sendAsset;
    }

    public String getSendMax() {
        return this.sendMax;
    }

    public String getDestination() {
        return this.destination;
    }

    public Asset getDestAsset() {
        return this.destAsset;
    }

    public String getDestAmount() {
        return this.destAmount;
    }

    public Asset[] getPath() {
        return this.path;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        PathPaymentStrictReceiveOp op = new PathPaymentStrictReceiveOp();
        op.setSendAsset(this.sendAsset.toXdr());
        Int64 sendMax = new Int64();
        sendMax.setInt64(Operation.toXdrAmount(this.sendMax));
        op.setSendMax(sendMax);
        op.setDestination(StrKey.encodeToXDRMuxedAccount(this.destination));
        op.setDestAsset(this.destAsset.toXdr());
        Int64 destAmount = new Int64();
        destAmount.setInt64(Operation.toXdrAmount(this.destAmount));
        op.setDestAmount(destAmount);
        org.stellar.sdk.xdr.Asset[] path = new org.stellar.sdk.xdr.Asset[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            path[i] = this.path[i].toXdr();
        }
        op.setPath(path);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.PATH_PAYMENT_STRICT_RECEIVE);
        body.setPathPaymentStrictReceiveOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceAccount(), this.destAmount, this.destAsset, this.destination, Arrays.hashCode(this.path), this.sendAsset, this.sendMax);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PathPaymentStrictReceiveOperation)) {
            return false;
        }
        PathPaymentStrictReceiveOperation other = (PathPaymentStrictReceiveOperation)object;
        return Objects.equal(this.getSourceAccount(), other.getSourceAccount()) && Objects.equal(this.destAmount, other.destAmount) && Objects.equal(this.destAsset, other.destAsset) && Objects.equal(this.destination, other.destination) && Arrays.equals(this.path, other.path) && Objects.equal(this.sendAsset, other.sendAsset) && Objects.equal(this.sendMax, other.sendMax);
    }

    public static class Builder {
        private final Asset sendAsset;
        private final String sendMax;
        private final String destination;
        private final Asset destAsset;
        private final String destAmount;
        private Asset[] path;
        private String mSourceAccount;

        Builder(PathPaymentStrictReceiveOp op) {
            this.sendAsset = Asset.fromXdr(op.getSendAsset());
            this.sendMax = Operation.fromXdrAmount(op.getSendMax().getInt64());
            this.destination = StrKey.encodeStellarAccountId(StrKey.muxedAccountToAccountId(op.getDestination()));
            this.destAsset = Asset.fromXdr(op.getDestAsset());
            this.destAmount = Operation.fromXdrAmount(op.getDestAmount().getInt64());
            this.path = new Asset[op.getPath().length];
            for (int i = 0; i < op.getPath().length; ++i) {
                this.path[i] = Asset.fromXdr(op.getPath()[i]);
            }
        }

        public Builder(Asset sendAsset, String sendMax, String destination, Asset destAsset, String destAmount) {
            this.sendAsset = Preconditions.checkNotNull(sendAsset, "sendAsset cannot be null");
            this.sendMax = Preconditions.checkNotNull(sendMax, "sendMax cannot be null");
            this.destination = Preconditions.checkNotNull(destination, "destination cannot be null");
            this.destAsset = Preconditions.checkNotNull(destAsset, "destAsset cannot be null");
            this.destAmount = Preconditions.checkNotNull(destAmount, "destAmount cannot be null");
        }

        public Builder setPath(Asset[] path) {
            Preconditions.checkNotNull(path, "path cannot be null");
            Preconditions.checkArgument(path.length <= 5, "The maximum number of assets in the path is 5");
            this.path = path;
            return this;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public PathPaymentStrictReceiveOperation build() {
            PathPaymentStrictReceiveOperation operation = new PathPaymentStrictReceiveOperation(this.sendAsset, this.sendMax, this.destination, this.destAsset, this.destAmount, this.path);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

