/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import org.stellar.sdk.AccountMergeOperation;
import org.stellar.sdk.AllowTrustOperation;
import org.stellar.sdk.BeginSponsoringFutureReservesOperation;
import org.stellar.sdk.BumpSequenceOperation;
import org.stellar.sdk.ChangeTrustOperation;
import org.stellar.sdk.ClaimClaimableBalanceOperation;
import org.stellar.sdk.CreateAccountOperation;
import org.stellar.sdk.CreateClaimableBalanceOperation;
import org.stellar.sdk.CreatePassiveSellOfferOperation;
import org.stellar.sdk.EndSponsoringFutureReservesOperation;
import org.stellar.sdk.InflationOperation;
import org.stellar.sdk.ManageBuyOfferOperation;
import org.stellar.sdk.ManageDataOperation;
import org.stellar.sdk.ManageSellOfferOperation;
import org.stellar.sdk.PathPaymentStrictReceiveOperation;
import org.stellar.sdk.PathPaymentStrictSendOperation;
import org.stellar.sdk.PaymentOperation;
import org.stellar.sdk.RevokeAccountSponsorshipOperation;
import org.stellar.sdk.RevokeClaimableBalanceSponsorshipOperation;
import org.stellar.sdk.RevokeDataSponsorshipOperation;
import org.stellar.sdk.RevokeOfferSponsorshipOperation;
import org.stellar.sdk.RevokeSignerSponsorshipOperation;
import org.stellar.sdk.RevokeTrustlineSponsorshipOperation;
import org.stellar.sdk.SetOptionsOperation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.io.BaseEncoding;

public abstract class Operation {
    private String mSourceAccount;
    private static final BigDecimal ONE = new BigDecimal(10).pow(7);

    Operation() {
    }

    protected static long toXdrAmount(String value) {
        value = Preconditions.checkNotNull(value, "value cannot be null");
        BigDecimal amount = new BigDecimal(value).multiply(ONE);
        return amount.longValueExact();
    }

    protected static String fromXdrAmount(long value) {
        BigDecimal amount = new BigDecimal(value).divide(ONE);
        return amount.toPlainString();
    }

    public org.stellar.sdk.xdr.Operation toXdr() {
        org.stellar.sdk.xdr.Operation xdr = new org.stellar.sdk.xdr.Operation();
        if (this.getSourceAccount() != null) {
            xdr.setSourceAccount(StrKey.encodeToXDRMuxedAccount(this.mSourceAccount));
        }
        xdr.setBody(this.toOperationBody());
        return xdr;
    }

    public String toXdrBase64() {
        try {
            org.stellar.sdk.xdr.Operation operation = this.toXdr();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrOutputStream = new XdrDataOutputStream(outputStream);
            org.stellar.sdk.xdr.Operation.encode(xdrOutputStream, operation);
            BaseEncoding base64Encoding = BaseEncoding.base64();
            return base64Encoding.encode(outputStream.toByteArray());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Operation fromXdr(org.stellar.sdk.xdr.Operation xdr) {
        Operation operation;
        Operation.OperationBody body = xdr.getBody();
        block0 : switch (body.getDiscriminant()) {
            case CREATE_ACCOUNT: {
                operation = new CreateAccountOperation.Builder(body.getCreateAccountOp()).build();
                break;
            }
            case PAYMENT: {
                operation = new PaymentOperation.Builder(body.getPaymentOp()).build();
                break;
            }
            case PATH_PAYMENT_STRICT_RECEIVE: {
                operation = new PathPaymentStrictReceiveOperation.Builder(body.getPathPaymentStrictReceiveOp()).build();
                break;
            }
            case MANAGE_SELL_OFFER: {
                operation = new ManageSellOfferOperation.Builder(body.getManageSellOfferOp()).build();
                break;
            }
            case MANAGE_BUY_OFFER: {
                operation = new ManageBuyOfferOperation.Builder(body.getManageBuyOfferOp()).build();
                break;
            }
            case CREATE_PASSIVE_SELL_OFFER: {
                operation = new CreatePassiveSellOfferOperation.Builder(body.getCreatePassiveSellOfferOp()).build();
                break;
            }
            case SET_OPTIONS: {
                operation = new SetOptionsOperation.Builder(body.getSetOptionsOp()).build();
                break;
            }
            case CHANGE_TRUST: {
                operation = new ChangeTrustOperation.Builder(body.getChangeTrustOp()).build();
                break;
            }
            case ALLOW_TRUST: {
                operation = new AllowTrustOperation.Builder(body.getAllowTrustOp()).build();
                break;
            }
            case ACCOUNT_MERGE: {
                operation = new AccountMergeOperation.Builder(body).build();
                break;
            }
            case INFLATION: {
                operation = new InflationOperation();
                break;
            }
            case MANAGE_DATA: {
                operation = new ManageDataOperation.Builder(body.getManageDataOp()).build();
                break;
            }
            case BUMP_SEQUENCE: {
                operation = new BumpSequenceOperation.Builder(body.getBumpSequenceOp()).build();
                break;
            }
            case PATH_PAYMENT_STRICT_SEND: {
                operation = new PathPaymentStrictSendOperation.Builder(body.getPathPaymentStrictSendOp()).build();
                break;
            }
            case CREATE_CLAIMABLE_BALANCE: {
                operation = new CreateClaimableBalanceOperation.Builder(body.getCreateClaimableBalanceOp()).build();
                break;
            }
            case CLAIM_CLAIMABLE_BALANCE: {
                operation = new ClaimClaimableBalanceOperation.Builder(body.getClaimClaimableBalanceOp()).build();
                break;
            }
            case BEGIN_SPONSORING_FUTURE_RESERVES: {
                operation = new BeginSponsoringFutureReservesOperation.Builder(body.getBeginSponsoringFutureReservesOp()).build();
                break;
            }
            case END_SPONSORING_FUTURE_RESERVES: {
                operation = new EndSponsoringFutureReservesOperation();
                break;
            }
            case REVOKE_SPONSORSHIP: {
                switch (body.getRevokeSponsorshipOp().getDiscriminant()) {
                    case REVOKE_SPONSORSHIP_SIGNER: {
                        operation = new RevokeSignerSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                        break block0;
                    }
                    case REVOKE_SPONSORSHIP_LEDGER_ENTRY: {
                        switch (body.getRevokeSponsorshipOp().getLedgerKey().getDiscriminant()) {
                            case DATA: {
                                operation = new RevokeDataSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                                break block0;
                            }
                            case OFFER: {
                                operation = new RevokeOfferSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                                break block0;
                            }
                            case ACCOUNT: {
                                operation = new RevokeAccountSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                                break block0;
                            }
                            case TRUSTLINE: {
                                operation = new RevokeTrustlineSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                                break block0;
                            }
                            case CLAIMABLE_BALANCE: {
                                operation = new RevokeClaimableBalanceSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                                break block0;
                            }
                        }
                        throw new RuntimeException("Unknown revoke sponsorship ledger entry type " + body.getRevokeSponsorshipOp().getLedgerKey().getDiscriminant());
                    }
                }
                throw new RuntimeException("Unknown revoke sponsorship body " + body.getRevokeSponsorshipOp().getDiscriminant());
            }
            default: {
                throw new RuntimeException("Unknown operation body " + body.getDiscriminant());
            }
        }
        if (xdr.getSourceAccount() != null) {
            operation.setSourceAccount(StrKey.encodeStellarAccountId(StrKey.muxedAccountToAccountId(xdr.getSourceAccount())));
        }
        return operation;
    }

    public String getSourceAccount() {
        return this.mSourceAccount;
    }

    void setSourceAccount(String sourceAccount) {
        this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
    }

    abstract Operation.OperationBody toOperationBody();
}

