/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Arrays;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.DataValue;
import org.stellar.sdk.xdr.ManageDataOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.XdrString;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class ManageDataOperation
extends Operation {
    private final String name;
    private final byte[] value;

    private ManageDataOperation(String name, byte[] value) {
        this.name = Preconditions.checkNotNull(name, "name cannot be null");
        this.value = value;
        if (new XdrString(this.name).getBytes().length > 64) {
            throw new IllegalArgumentException("name cannot exceed 64 bytes");
        }
    }

    public String getName() {
        return this.name;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        ManageDataOp op = new ManageDataOp();
        String64 name = new String64();
        name.setString64(new XdrString(this.name));
        op.setDataName(name);
        if (this.value != null) {
            DataValue dataValue = new DataValue();
            dataValue.setDataValue(this.value);
            op.setDataValue(dataValue);
        }
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.MANAGE_DATA);
        body.setManageDataOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceAccount(), this.name, Arrays.hashCode(this.value));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ManageDataOperation)) {
            return false;
        }
        ManageDataOperation other = (ManageDataOperation)object;
        return Objects.equal(this.getSourceAccount(), other.getSourceAccount()) && Objects.equal(this.name, other.name) && Arrays.equals(this.value, other.value);
    }

    public static class Builder {
        private final String name;
        private final byte[] value;
        private String mSourceAccount;

        Builder(ManageDataOp op) {
            this.name = op.getDataName().getString64().toString();
            this.value = (byte[])(op.getDataValue() != null ? op.getDataValue().getDataValue() : null);
        }

        public Builder(String name, byte[] value) {
            this.name = Preconditions.checkNotNull(name, "name cannot be null");
            this.value = value;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public ManageDataOperation build() {
            ManageDataOperation operation = new ManageDataOperation(this.name, this.value);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

