/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Price;
import org.stellar.sdk.xdr.CreatePassiveSellOfferOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class CreatePassiveSellOfferOperation
extends Operation {
    private final Asset selling;
    private final Asset buying;
    private final String amount;
    private final String price;

    private CreatePassiveSellOfferOperation(Asset selling, Asset buying, String amount, String price) {
        this.selling = Preconditions.checkNotNull(selling, "selling cannot be null");
        this.buying = Preconditions.checkNotNull(buying, "buying cannot be null");
        this.amount = Preconditions.checkNotNull(amount, "amount cannot be null");
        this.price = Preconditions.checkNotNull(price, "price cannot be null");
    }

    public Asset getSelling() {
        return this.selling;
    }

    public Asset getBuying() {
        return this.buying;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getPrice() {
        return this.price;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        CreatePassiveSellOfferOp op = new CreatePassiveSellOfferOp();
        op.setSelling(this.selling.toXdr());
        op.setBuying(this.buying.toXdr());
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        Price price = Price.fromString(this.price);
        op.setPrice(price.toXdr());
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CREATE_PASSIVE_SELL_OFFER);
        body.setCreatePassiveSellOfferOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.amount, this.buying, this.price, this.selling, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CreatePassiveSellOfferOperation)) {
            return false;
        }
        CreatePassiveSellOfferOperation other = (CreatePassiveSellOfferOperation)object;
        return Objects.equal(this.amount, other.amount) && Objects.equal(this.buying, other.buying) && Objects.equal(this.price, other.price) && Objects.equal(this.selling, other.selling) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final Asset selling;
        private final Asset buying;
        private final String amount;
        private final String price;
        private String mSourceAccount;

        Builder(CreatePassiveSellOfferOp op) {
            this.selling = Asset.fromXdr(op.getSelling());
            this.buying = Asset.fromXdr(op.getBuying());
            this.amount = Operation.fromXdrAmount(op.getAmount().getInt64());
            this.price = Price.fromXdr(op.getPrice()).toString();
        }

        public Builder(Asset selling, Asset buying, String amount, String price) {
            this.selling = Preconditions.checkNotNull(selling, "selling cannot be null");
            this.buying = Preconditions.checkNotNull(buying, "buying cannot be null");
            this.amount = Preconditions.checkNotNull(amount, "amount cannot be null");
            this.price = Preconditions.checkNotNull(price, "price cannot be null");
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public CreatePassiveSellOfferOperation build() {
            CreatePassiveSellOfferOperation operation = new CreatePassiveSellOfferOperation(this.selling, this.buying, this.amount, this.price);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

