/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.ClaimClaimableBalanceOp;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.io.BaseEncoding;

public class ClaimClaimableBalanceOperation
extends Operation {
    private final String balanceId;

    private ClaimClaimableBalanceOperation(String balanceId) {
        this.balanceId = Preconditions.checkNotNull(balanceId, "balanceId cannot be null");
    }

    public String getBalanceId() {
        return this.balanceId;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        ClaimableBalanceID id;
        ClaimClaimableBalanceOp op = new ClaimClaimableBalanceOp();
        byte[] balanceIdBytes = BaseEncoding.base16().lowerCase().decode(this.balanceId.toLowerCase());
        XdrDataInputStream balanceIdXdrDataInputStream = new XdrDataInputStream(new ByteArrayInputStream(balanceIdBytes));
        try {
            id = ClaimableBalanceID.decode(balanceIdXdrDataInputStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid balanceId: " + this.balanceId, e);
        }
        op.setBalanceID(id);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CLAIM_CLAIMABLE_BALANCE);
        body.setClaimClaimableBalanceOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.balanceId, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ClaimClaimableBalanceOperation)) {
            return false;
        }
        ClaimClaimableBalanceOperation other = (ClaimClaimableBalanceOperation)object;
        return Objects.equal(this.balanceId, other.balanceId) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String balanceId;
        private String mSourceAccount;

        Builder(ClaimClaimableBalanceOp op) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            try {
                op.getBalanceID().encode(xdrDataOutputStream);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("invalid claimClaimableBalanceOp.", e);
            }
            this.balanceId = BaseEncoding.base16().lowerCase().encode(byteArrayOutputStream.toByteArray());
        }

        public Builder(String balanceId) {
            this.balanceId = balanceId;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public ClaimClaimableBalanceOperation build() {
            ClaimClaimableBalanceOperation operation = new ClaimClaimableBalanceOperation(this.balanceId);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

