/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.ChangeTrustOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class ChangeTrustOperation
extends Operation {
    private final Asset asset;
    private final String limit;

    private ChangeTrustOperation(Asset asset, String limit) {
        this.asset = Preconditions.checkNotNull(asset, "asset cannot be null");
        this.limit = Preconditions.checkNotNull(limit, "limit cannot be null");
    }

    public Asset getAsset() {
        return this.asset;
    }

    public String getLimit() {
        return this.limit;
    }

    @Override
    Operation.OperationBody toOperationBody() {
        ChangeTrustOp op = new ChangeTrustOp();
        op.setLine(this.asset.toXdr());
        Int64 limit = new Int64();
        limit.setInt64(Operation.toXdrAmount(this.limit));
        op.setLimit(limit);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CHANGE_TRUST);
        body.setChangeTrustOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.asset, this.limit, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ChangeTrustOperation)) {
            return false;
        }
        ChangeTrustOperation other = (ChangeTrustOperation)object;
        return Objects.equal(this.asset, other.asset) && Objects.equal(this.limit, other.limit) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final Asset asset;
        private final String limit;
        private String mSourceAccount;

        Builder(ChangeTrustOp op) {
            this.asset = Asset.fromXdr(op.getLine());
            this.limit = Operation.fromXdrAmount(op.getLimit().getInt64());
        }

        public Builder(Asset asset, String limit) {
            this.asset = Preconditions.checkNotNull(asset, "asset cannot be null");
            this.limit = Preconditions.checkNotNull(limit, "limit cannot be null");
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public ChangeTrustOperation build() {
            ChangeTrustOperation operation = new ChangeTrustOperation(this.asset, this.limit);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

