/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AssetCodeLengthInvalidException;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.AssetCode4;
import org.stellar.sdk.xdr.AssetType;

public final class AssetTypeCreditAlphaNum4
extends AssetTypeCreditAlphaNum {
    public AssetTypeCreditAlphaNum4(String code, String issuer) {
        super(code, issuer);
        if (code.length() < 1 || code.length() > 4) {
            throw new AssetCodeLengthInvalidException();
        }
    }

    @Override
    public String getType() {
        return "credit_alphanum4";
    }

    @Override
    public Asset toXdr() {
        Asset xdr = new Asset();
        xdr.setDiscriminant(AssetType.ASSET_TYPE_CREDIT_ALPHANUM4);
        Asset.AssetAlphaNum4 credit = new Asset.AssetAlphaNum4();
        AssetCode4 assetCode4 = new AssetCode4();
        assetCode4.setAssetCode4(Util.paddedByteArray(this.mCode, 4));
        credit.setAssetCode(assetCode4);
        credit.setIssuer(StrKey.encodeToXDRAccountId(this.mIssuer));
        xdr.setAlphaNum4(credit);
        return xdr;
    }
}

