/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AssetCodeLengthInvalidException;
import org.stellar.sdk.AssetTypeCreditAlphaNum12;
import org.stellar.sdk.AssetTypeCreditAlphaNum4;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;

public abstract class Asset {
    Asset() {
    }

    public static Asset create(String canonicalForm) {
        if (canonicalForm.equals("native")) {
            return new AssetTypeNative();
        }
        String[] parts = canonicalForm.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("invalid asset " + canonicalForm);
        }
        return Asset.createNonNativeAsset(parts[0], parts[1]);
    }

    public static Asset create(String type, String code, String issuer) {
        if (type.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(code, issuer);
    }

    public static Asset createNonNativeAsset(String code, String issuer) {
        if (code.length() >= 1 && code.length() <= 4) {
            return new AssetTypeCreditAlphaNum4(code, issuer);
        }
        if (code.length() >= 5 && code.length() <= 12) {
            return new AssetTypeCreditAlphaNum12(code, issuer);
        }
        throw new AssetCodeLengthInvalidException();
    }

    public static Asset fromXdr(org.stellar.sdk.xdr.Asset xdr) {
        switch (xdr.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                return new AssetTypeNative();
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                String assetCode4 = Util.paddedByteArrayToString(xdr.getAlphaNum4().getAssetCode().getAssetCode4());
                String accountId = StrKey.encodeStellarAccountId(xdr.getAlphaNum4().getIssuer());
                return new AssetTypeCreditAlphaNum4(assetCode4, accountId);
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                String assetCode12 = Util.paddedByteArrayToString(xdr.getAlphaNum12().getAssetCode().getAssetCode12());
                String accountId = StrKey.encodeStellarAccountId(xdr.getAlphaNum12().getIssuer());
                return new AssetTypeCreditAlphaNum12(assetCode12, accountId);
            }
        }
        throw new IllegalArgumentException("Unknown asset type " + xdr.getDiscriminant());
    }

    public abstract String getType();

    public abstract boolean equals(Object var1);

    public abstract org.stellar.sdk.xdr.Asset toXdr();
}

