/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.KeyPair;
import org.stellar.sdk.TransactionBuilderAccount;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class Account
implements TransactionBuilderAccount {
    private final String mAccountId;
    private Long mSequenceNumber;

    public Account(String accountId, Long sequenceNumber) {
        this.mAccountId = Preconditions.checkNotNull(accountId, "accountId cannot be null");
        this.mSequenceNumber = Preconditions.checkNotNull(sequenceNumber, "sequenceNumber cannot be null");
    }

    @Override
    public String getAccountId() {
        return this.mAccountId;
    }

    @Override
    public KeyPair getKeyPair() {
        return KeyPair.fromAccountId(this.mAccountId);
    }

    @Override
    public Long getSequenceNumber() {
        return this.mSequenceNumber;
    }

    @Override
    public Long getIncrementedSequenceNumber() {
        return new Long(this.mSequenceNumber + 1L);
    }

    @Override
    public void incrementSequenceNumber() {
        Long l = this.mSequenceNumber;
        Long l2 = this.mSequenceNumber = Long.valueOf(this.mSequenceNumber + 1L);
    }

    public int hashCode() {
        return Objects.hashCode(this.mAccountId, this.mSequenceNumber);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Account)) {
            return false;
        }
        Account other = (Account)object;
        return Objects.equal(this.mAccountId, other.mAccountId) && Objects.equal(this.mSequenceNumber, other.mSequenceNumber);
    }
}

