/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane.component;

import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CycleButton
extends Pane {
    private final List<Pane> panes = new ArrayList<Pane>();
    private int position = 0;

    public CycleButton(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        super(x, y, length, height, priority);
    }

    public CycleButton(int x, int y, int length, int height) {
        super(x, y, length, height);
    }

    public CycleButton(int length, int height) {
        super(length, height);
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        int adjustedSlot = slot - (this.getX() + paneOffsetX) - inventoryComponent.getLength() * (this.getY() + paneOffsetY);
        int x = adjustedSlot % inventoryComponent.getLength();
        int y = adjustedSlot / inventoryComponent.getLength();
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        int previousPosition = this.position++;
        if (this.position == this.panes.size()) {
            this.position = 0;
        }
        this.callOnClick(event);
        Pane pane = this.panes.get(previousPosition);
        pane.click(gui, inventoryComponent, event, slot, paneOffsetX + x, paneOffsetY + y, length, height);
        gui.update();
        return true;
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int newX = paneOffsetX + this.x;
        int newY = paneOffsetY + this.y;
        int newMaxLength = Math.min(maxLength, this.length);
        int newMaxHeight = Math.min(maxHeight, this.height);
        this.panes.get(this.position).display(inventoryComponent, newX, newY, newMaxLength, newMaxHeight);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public CycleButton copy() {
        CycleButton cycleButton = new CycleButton(this.x, this.y, this.length, this.height, this.getPriority());
        for (Pane pane : this.panes) {
            cycleButton.addPane(pane);
        }
        cycleButton.setVisible(this.isVisible());
        cycleButton.onClick = this.onClick;
        cycleButton.position = this.position;
        cycleButton.uuid = this.uuid;
        return cycleButton;
    }

    @Override
    @NotNull
    public Collection<GuiItem> getItems() {
        return this.getPanes().stream().flatMap(pane -> pane.getItems().stream()).collect(Collectors.toList());
    }

    public void addPane(int index, @NotNull Pane pane) {
        this.panes.add(index, pane);
    }

    public void addPane(@NotNull Pane pane) {
        this.panes.add(pane);
    }

    @Override
    public void clear() {
        this.panes.clear();
    }

    @Override
    @NotNull
    public Collection<Pane> getPanes() {
        return this.panes;
    }

    public void cycle() {
        ++this.position;
    }

    @NotNull
    public static CycleButton load(@NotNull Object instance, @NotNull Element element) {
        int height;
        int length;
        try {
            length = Integer.parseInt(element.getAttribute("length"));
            height = Integer.parseInt(element.getAttribute("height"));
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
        CycleButton cycleButton = new CycleButton(length, height);
        Pane.load(cycleButton, instance, element);
        if (element.hasAttribute("populate")) {
            return cycleButton;
        }
        NodeList childNodes = element.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node pane = childNodes.item(j);
            if (pane.getNodeType() != 1) continue;
            cycleButton.addPane(Gui.loadPane(instance, pane));
        }
        return cycleButton;
    }
}

