/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefanbirkner.editors.mapper;

import com.github.stefanbirkner.editors.mapper.Mapper;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperBuilder<T> {
    private final Map<T, String> textsForValues = new HashMap<T, String>();
    private T defaultValue = null;
    private String defaultText = null;

    public void addMapping(T value, String text) {
        this.textsForValues.put(value, text);
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Mapper<T> toMapper() {
        return new MapBasedMapper<T>(this.textsForValues, this.defaultValue, this.defaultText);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapBasedMapper<T>
    implements Mapper<T> {
        private final Map<String, T> valuesForTexts = new HashMap<String, T>();
        private final Map<T, String> textsForValues;
        private final String defaultText;
        private final T defaultValue;

        public MapBasedMapper(Map<T, String> textsForValues, T defaultValue, String defaultText) {
            this.defaultValue = defaultValue;
            this.textsForValues = new HashMap<T, String>(textsForValues);
            this.defaultText = defaultText;
            for (Map.Entry<T, String> valueAndText : textsForValues.entrySet()) {
                this.valuesForTexts.put(valueAndText.getValue(), valueAndText.getKey());
            }
        }

        @Override
        public T getValueForText(String text) {
            T value = this.valuesForTexts.get(text);
            return this.defaultIfNull(value, this.defaultValue);
        }

        @Override
        public String getTextForValue(T value) {
            String text = this.textsForValues.get(value);
            return this.defaultIfNull(text, this.defaultText);
        }

        private <S> S defaultIfNull(S value, S valueIfNull) {
            return value == null ? valueIfNull : value;
        }
    }
}

