/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import android.util.Base64;
import com.statsig.androidsdk.BoundedMemo;
import com.statsig.androidsdk.HashAlgorithm;
import com.statsig.androidsdk.Hashing;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/statsig/androidsdk/Hashing;", "", "()V", "djb2Cache", "Lcom/statsig/androidsdk/BoundedMemo;", "", "sha256Cache", "getDJB2HashString", "input", "getHashedString", "algorithm", "Lcom/statsig/androidsdk/HashAlgorithm;", "getSHA256HashString", "android-sdk_release"})
public final class Hashing {
    @NotNull
    public static final Hashing INSTANCE = new Hashing();
    @NotNull
    private static final BoundedMemo<String, String> sha256Cache = new BoundedMemo();
    @NotNull
    private static final BoundedMemo<String, String> djb2Cache = new BoundedMemo();

    private Hashing() {
    }

    @NotNull
    public final String getHashedString(@NotNull String input, @Nullable HashAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        HashAlgorithm hashAlgorithm = algorithm;
        return switch (hashAlgorithm == null ? -1 : WhenMappings.$EnumSwitchMapping$0[hashAlgorithm.ordinal()]) {
            case 1 -> djb2Cache.computeIfAbsent(input, (Function1<String, String>)((Function1)getHashedString.1.INSTANCE));
            case 2 -> sha256Cache.computeIfAbsent(input, (Function1<String, String>)((Function1)getHashedString.2.INSTANCE));
            case 3 -> input;
            default -> sha256Cache.computeIfAbsent(input, (Function1<String, String>)((Function1)getHashedString.3.INSTANCE));
        };
    }

    private final String getSHA256HashString(String input) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        String string = input;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] inputBytes = byArray;
        byte[] bytes = md.digest(inputBytes);
        String string2 = Base64.encodeToString((byte[])bytes, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    @NotNull
    public final String getDJB2HashString(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int hash = 0;
        char[] cArray = input.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char c : cArray) {
            hash = (hash << 5) - hash + c;
            hash &= hash;
        }
        return Integer.toUnsignedString(UInt.constructor-impl((int)hash));
    }

    public static final /* synthetic */ String access$getSHA256HashString(Hashing $this, String input) {
        return $this.getSHA256HashString(input);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HashAlgorithm.values().length];
            try {
                nArray[HashAlgorithm.DJB2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HashAlgorithm.SHA256.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HashAlgorithm.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

