/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import android.util.Log;
import com.google.gson.Gson;
import com.statsig.androidsdk.DynamicConfig;
import com.statsig.androidsdk.EvaluationDetails;
import com.statsig.androidsdk.EvaluationReason;
import com.statsig.androidsdk.FeatureGate;
import com.statsig.androidsdk.Layer;
import com.statsig.androidsdk.ParameterStore;
import com.statsig.androidsdk.StatsigClient;
import com.statsig.androidsdk.StatsigUser;
import com.statsig.androidsdk.StatsigUtil;
import com.statsig.androidsdk.evaluator.ConfigEvaluation;
import com.statsig.androidsdk.evaluator.Evaluator;
import com.statsig.androidsdk.evaluator.SpecParamStore;
import com.statsig.androidsdk.evaluator.SpecStore;
import com.statsig.androidsdk.evaluator.SpecsResponse;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001cH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/statsig/androidsdk/OnDeviceEvalAdapter;", "", "data", "", "<init>", "(Ljava/lang/String;)V", "store", "Lcom/statsig/androidsdk/evaluator/SpecStore;", "evaluator", "Lcom/statsig/androidsdk/evaluator/Evaluator;", "gson", "Lcom/google/gson/Gson;", "setData", "", "getGate", "Lcom/statsig/androidsdk/FeatureGate;", "current", "user", "Lcom/statsig/androidsdk/StatsigUser;", "getDynamicConfig", "Lcom/statsig/androidsdk/DynamicConfig;", "getLayer", "Lcom/statsig/androidsdk/Layer;", "client", "Lcom/statsig/androidsdk/StatsigClient;", "getParamStore", "Lcom/statsig/androidsdk/ParameterStore;", "shouldTryOnDeviceEvaluation", "", "details", "Lcom/statsig/androidsdk/EvaluationDetails;", "getEvaluationDetails", "isUnrecognized", "Companion", "android-sdk_release"})
@SourceDebugExtension(value={"SMAP\nOnDeviceEvalAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnDeviceEvalAdapter.kt\ncom/statsig/androidsdk/OnDeviceEvalAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class OnDeviceEvalAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String data;
    @NotNull
    private final SpecStore store;
    @NotNull
    private final Evaluator evaluator;
    @NotNull
    private final Gson gson;
    @NotNull
    private static final String TAG = "statsig::OnDeviceEval";

    public OnDeviceEvalAdapter(@Nullable String data) {
        block0: {
            this.data = data;
            this.store = new SpecStore();
            this.evaluator = new Evaluator(this.store);
            this.gson = StatsigUtil.INSTANCE.getGson$android_sdk_release();
            String string = this.data;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.setData(it);
        }
    }

    public final void setData(@NotNull String data) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            object = this.gson.fromJson(data, SpecsResponse.class);
            Intrinsics.checkNotNull((Object)object);
            object = (SpecsResponse)object;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to parse specs from data string");
            return;
        }
        Object specs = object;
        this.store.setSpecs((SpecsResponse)specs);
    }

    @Nullable
    public final FeatureGate getGate(@NotNull FeatureGate current, @NotNull StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!this.shouldTryOnDeviceEvaluation(current.getEvaluationDetails())) {
            return null;
        }
        String gateName = current.getName();
        ConfigEvaluation evaluation = this.evaluator.evaluateGate$android_sdk_release(gateName, user);
        EvaluationDetails details = this.getEvaluationDetails(evaluation.isUnrecognized());
        return new FeatureGate(gateName, evaluation, details);
    }

    @Nullable
    public final DynamicConfig getDynamicConfig(@NotNull DynamicConfig current, @NotNull StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!this.shouldTryOnDeviceEvaluation(current.getEvaluationDetails())) {
            return null;
        }
        String configName = current.getName();
        ConfigEvaluation evaluation = this.evaluator.evaluateConfig$android_sdk_release(configName, user);
        EvaluationDetails details = this.getEvaluationDetails(evaluation.isUnrecognized());
        return new DynamicConfig(configName, evaluation, details);
    }

    @Nullable
    public final Layer getLayer(@Nullable StatsigClient client, @NotNull Layer current, @NotNull StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!this.shouldTryOnDeviceEvaluation(current.getEvaluationDetails())) {
            return null;
        }
        String layerName = current.getName();
        ConfigEvaluation evaluation = this.evaluator.evaluateLayer$android_sdk_release(layerName, user);
        EvaluationDetails details = this.getEvaluationDetails(evaluation.isUnrecognized());
        return new Layer(client, layerName, evaluation, details);
    }

    @Nullable
    public final ParameterStore getParamStore(@NotNull StatsigClient client, @NotNull ParameterStore current) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        if (!this.shouldTryOnDeviceEvaluation(current.getEvaluationDetails())) {
            return null;
        }
        SpecParamStore spec = this.store.getParamStore(current.getName());
        EvaluationDetails details = this.getEvaluationDetails(spec == null);
        Object object = spec;
        if (object == null || (object = ((SpecParamStore)object).getParameters()) == null) {
            object = MapsKt.emptyMap();
        }
        return new ParameterStore(client, (Map<String, ? extends Map<String, ? extends Object>>)object, current.getName(), details, null);
    }

    private final boolean shouldTryOnDeviceEvaluation(EvaluationDetails details) {
        SpecsResponse specsResponse = this.store.getRawSpecs();
        if (specsResponse == null) {
            return false;
        }
        SpecsResponse specs = specsResponse;
        return specs.getTime() > details.getLcut();
    }

    private final EvaluationDetails getEvaluationDetails(boolean isUnrecognized) {
        long lcut;
        Long l = this.store.getLcut();
        long l2 = lcut = l != null ? l : 0L;
        if (isUnrecognized) {
            return new EvaluationDetails(EvaluationReason.OnDeviceEvalAdapterBootstrapUnrecognized, 0L, lcut, 2, null);
        }
        return new EvaluationDetails(EvaluationReason.OnDeviceEvalAdapterBootstrapRecognized, 0L, lcut, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/statsig/androidsdk/OnDeviceEvalAdapter$Companion;", "", "<init>", "()V", "TAG", "", "android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

