/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import android.util.Base64;
import com.statsig.androidsdk.BoundedMemo;
import com.statsig.androidsdk.HashAlgorithm;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/statsig/androidsdk/Hashing;", "", "<init>", "()V", "sha256Cache", "Lcom/statsig/androidsdk/BoundedMemo;", "", "djb2Cache", "getHashedString", "input", "algorithm", "Lcom/statsig/androidsdk/HashAlgorithm;", "getSHA256HashString", "getDJB2HashString", "android-sdk_release"})
public final class Hashing {
    @NotNull
    public static final Hashing INSTANCE = new Hashing();
    @NotNull
    private static final BoundedMemo<String, String> sha256Cache = new BoundedMemo();
    @NotNull
    private static final BoundedMemo<String, String> djb2Cache = new BoundedMemo();

    private Hashing() {
    }

    @NotNull
    public final String getHashedString(@NotNull String input, @Nullable HashAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        HashAlgorithm hashAlgorithm = algorithm;
        return switch (hashAlgorithm == null ? -1 : WhenMappings.$EnumSwitchMapping$0[hashAlgorithm.ordinal()]) {
            case 1 -> djb2Cache.computeIfAbsent(input, (Function1<String, String>)((Function1)Hashing::getHashedString$lambda$0));
            case 2 -> sha256Cache.computeIfAbsent(input, (Function1<String, String>)((Function1)Hashing::getHashedString$lambda$1));
            case 3 -> input;
            default -> sha256Cache.computeIfAbsent(input, (Function1<String, String>)((Function1)Hashing::getHashedString$lambda$2));
        };
    }

    private final String getSHA256HashString(String input) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        String string = input;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] inputBytes = byArray;
        byte[] bytes = md.digest(inputBytes);
        String string2 = Base64.encodeToString((byte[])bytes, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    @NotNull
    public final String getDJB2HashString(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int hash = 0;
        char[] cArray = input.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char c : cArray) {
            hash = (hash << 5) - hash + c;
            hash &= hash;
        }
        return Integer.toUnsignedString(UInt.constructor-impl((int)hash));
    }

    private static final String getHashedString$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.getDJB2HashString(it);
    }

    private static final String getHashedString$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.getSHA256HashString(it);
    }

    private static final String getHashedString$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.getSHA256HashString(it);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HashAlgorithm.values().length];
            try {
                nArray[HashAlgorithm.DJB2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HashAlgorithm.SHA256.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HashAlgorithm.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

