/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import com.statsig.androidsdk.CoroutineDispatcherProvider;
import com.statsig.androidsdk.DnsTxtFetchError;
import com.statsig.androidsdk.DnsTxtParseError;
import com.statsig.androidsdk.UrlConnectionProvider;
import com.statsig.androidsdk.UrlConnectionProviderKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0016\u001a\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u001b\u001a\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"FEATURE_ASSETS_DNS_QUERY", "", "getFEATURE_ASSETS_DNS_QUERY", "()[B", "DNS_QUERY_ENDPOINT", "", "DOMAIN_CHARS", "", "", "getDOMAIN_CHARS", "()Ljava/util/List;", "MAX_START_LOOKUP", "", "coroutineDispatcherProvider", "Lcom/statsig/androidsdk/CoroutineDispatcherProvider;", "getCoroutineDispatcherProvider", "()Lcom/statsig/androidsdk/CoroutineDispatcherProvider;", "coroutineDispatcherProvider$delegate", "Lkotlin/Lazy;", "fetchTxtRecords", "urlConnectionProvider", "Lcom/statsig/androidsdk/UrlConnectionProvider;", "(Lcom/statsig/androidsdk/UrlConnectionProvider;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createHttpConnection", "Ljava/net/HttpURLConnection;", "url", "parseDnsResponse", "input", "android-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDnsTxtQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnsTxtQuery.kt\ncom/statsig/androidsdk/DnsTxtQueryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n346#2,8:87\n*S KotlinDebug\n*F\n+ 1 DnsTxtQuery.kt\ncom/statsig/androidsdk/DnsTxtQueryKt\n*L\n70#1:87,8\n*E\n"})
public final class DnsTxtQueryKt {
    @NotNull
    private static final byte[] FEATURE_ASSETS_DNS_QUERY;
    @NotNull
    public static final String DNS_QUERY_ENDPOINT = "https://cloudflare-dns.com/dns-query";
    @NotNull
    private static final List<Character> DOMAIN_CHARS;
    public static final int MAX_START_LOOKUP = 200;
    @NotNull
    private static final Lazy coroutineDispatcherProvider$delegate;

    @NotNull
    public static final byte[] getFEATURE_ASSETS_DNS_QUERY() {
        return FEATURE_ASSETS_DNS_QUERY;
    }

    @NotNull
    public static final List<Character> getDOMAIN_CHARS() {
        return DOMAIN_CHARS;
    }

    private static final CoroutineDispatcherProvider getCoroutineDispatcherProvider() {
        Lazy lazy = coroutineDispatcherProvider$delegate;
        return (CoroutineDispatcherProvider)lazy.getValue();
    }

    @Nullable
    public static final Object fetchTxtRecords(@NotNull UrlConnectionProvider urlConnectionProvider, @NotNull Continuation<? super List<String>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)DnsTxtQueryKt.getCoroutineDispatcherProvider().getIo()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(urlConnectionProvider, null){
            int label;
            final /* synthetic */ UrlConnectionProvider $urlConnectionProvider;
            {
                this.$urlConnectionProvider = $urlConnectionProvider;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        HttpURLConnection connection = DnsTxtQueryKt.access$createHttpConnection("https://cloudflare-dns.com/dns-query", this.$urlConnectionProvider);
                        try {
                            Object object;
                            Closeable closeable = connection.getOutputStream();
                            Throwable throwable = null;
                            try {
                                ByteArrayOutputStream byteArrayOutputStream;
                                OutputStream outputStream = (OutputStream)closeable;
                                boolean bl = false;
                                ByteArrayOutputStream $this$invokeSuspend_u24lambda_u240_u240 = byteArrayOutputStream = new ByteArrayOutputStream();
                                boolean bl2 = false;
                                $this$invokeSuspend_u24lambda_u240_u240.write(DnsTxtQueryKt.getFEATURE_ASSETS_DNS_QUERY());
                                byte[] byteArray = byteArrayOutputStream.toByteArray();
                                outputStream.write(byteArray);
                                object = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            if (connection.getResponseCode() != 200) {
                                throw new DnsTxtFetchError("Failed to fetch TXT records from DNS");
                            }
                            InputStream inputStream = connection.getInputStream();
                            Intrinsics.checkNotNull((Object)inputStream);
                            byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
                            object = DnsTxtQueryKt.parseDnsResponse(bytes);
                            return object;
                        }
                        catch (Exception e) {
                            throw new DnsTxtFetchError("Request timed out while fetching TXT records");
                        }
                        finally {
                            connection.disconnect();
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object fetchTxtRecords$default(UrlConnectionProvider urlConnectionProvider, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            urlConnectionProvider = UrlConnectionProviderKt.getDefaultProvider();
        }
        return DnsTxtQueryKt.fetchTxtRecords(urlConnectionProvider, (Continuation<? super List<String>>)continuation);
    }

    private static final HttpURLConnection createHttpConnection(String url, UrlConnectionProvider urlConnectionProvider) {
        HttpURLConnection connection;
        HttpURLConnection httpURLConnection;
        URLConnection uRLConnection = urlConnectionProvider.open(new URL(url));
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection $this$createHttpConnection_u24lambda_u240 = httpURLConnection = (connection = (HttpURLConnection)uRLConnection);
        boolean bl = false;
        $this$createHttpConnection_u24lambda_u240.setRequestMethod("POST");
        $this$createHttpConnection_u24lambda_u240.setRequestProperty("Content-Type", "application/dns-message");
        $this$createHttpConnection_u24lambda_u240.setRequestProperty("Accept", "application/dns-message");
        $this$createHttpConnection_u24lambda_u240.setDoOutput(true);
        return connection;
    }

    static /* synthetic */ HttpURLConnection createHttpConnection$default(String string, UrlConnectionProvider urlConnectionProvider, int n, Object object) {
        if ((n & 2) != 0) {
            urlConnectionProvider = UrlConnectionProviderKt.getDefaultProvider();
        }
        return DnsTxtQueryKt.createHttpConnection(string, urlConnectionProvider);
    }

    @NotNull
    public static final List<String> parseDnsResponse(@NotNull byte[] input) {
        int startIndex;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Iterable $this$indexOfFirst$iv = ArraysKt.withIndex((byte[])input);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IndexedValue indexedValue = (IndexedValue)item$iv;
                boolean bl = false;
                int index = indexedValue.component1();
                byte by = ((Number)indexedValue.component2()).byteValue();
                if (index < 200 && (char)by == '=' && index > 0 && DOMAIN_CHARS.contains(Character.valueOf((char)input[index - 1]))) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = startIndex = -1;
        }
        if (startIndex == -1) {
            throw new DnsTxtParseError("Failed to parse TXT records from DNS");
        }
        Object[] objectArray = ArraysKt.copyOfRange((byte[])input, (int)(startIndex - 1), (int)input.length);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String result = new String((byte[])objectArray, charset2);
        objectArray = new String[1];
        objectArray[0] = (byte)",";
        return StringsKt.split$default((CharSequence)result, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
    }

    private static final CoroutineDispatcherProvider coroutineDispatcherProvider_delegate$lambda$0() {
        return new CoroutineDispatcherProvider(null, null, null, 7, null);
    }

    public static final /* synthetic */ HttpURLConnection access$createHttpConnection(String url, UrlConnectionProvider urlConnectionProvider) {
        return DnsTxtQueryKt.createHttpConnection(url, urlConnectionProvider);
    }

    static {
        Object[] objectArray = new byte[]{0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 13, 102, 101, 97, 116, 117, 114, 101, 97, 115, 115, 101, 116, 115, 3, 111, 114, 103, 0, 0, 16, 0, 1};
        FEATURE_ASSETS_DNS_QUERY = objectArray;
        objectArray = new Character[3];
        objectArray[0] = (byte)Character.valueOf('i');
        objectArray[1] = (byte)Character.valueOf('e');
        objectArray[2] = (byte)Character.valueOf('d');
        DOMAIN_CHARS = CollectionsKt.listOf((Object[])objectArray);
        coroutineDispatcherProvider$delegate = LazyKt.lazy(DnsTxtQueryKt::coroutineDispatcherProvider_delegate$lambda$0);
    }
}

