/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.statsig.androidsdk.APIDynamicConfig;
import com.statsig.androidsdk.APIFeatureGate;
import com.statsig.androidsdk.DynamicConfig;
import com.statsig.androidsdk.InitializeResponse;
import com.statsig.androidsdk.Statsig;
import com.statsig.androidsdk.StatsigUtil;
import com.statsig.androidsdk.StickyUserExperiments;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/statsig/androidsdk/Store;", "", "userID", "", "(Ljava/lang/String;)V", "cache", "Lcom/statsig/androidsdk/InitializeResponse;", "gson", "Lcom/google/gson/Gson;", "stickyDeviceExperiments", "", "Lcom/statsig/androidsdk/APIDynamicConfig;", "stickyUserExperiments", "Lcom/statsig/androidsdk/StickyUserExperiments;", "cacheStickyValues", "", "checkGate", "Lcom/statsig/androidsdk/APIFeatureGate;", "gateName", "getConfig", "Lcom/statsig/androidsdk/DynamicConfig;", "configName", "getExperiment", "experimentName", "keepDeviceValue", "", "loadAndResetStickyUserValues", "newUserID", "removeStickyValue", "key", "save", "data", "build_release"})
public final class Store {
    @NotNull
    private final Gson gson = new Gson();
    @NotNull
    private InitializeResponse cache;
    @NotNull
    private Map<String, APIDynamicConfig> stickyDeviceExperiments;
    private StickyUserExperiments stickyUserExperiments;

    public Store(@Nullable String userID) {
        String cachedResponse = Statsig.INSTANCE.getSharedPrefs$build_release().getString("Statsig.INITIALIZE_RESPONSE", null);
        String cachedDeviceValues = Statsig.INSTANCE.getSharedPrefs$build_release().getString("Statsig.STICKY_DEVICE_EXPERIMENTS", null);
        boolean bl = false;
        bl = false;
        this.cache = new InitializeResponse(MapsKt.emptyMap(), MapsKt.emptyMap(), false, 0L);
        if (cachedResponse != null) {
            Object object = this.gson.fromJson(cachedResponse, InitializeResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(cachedResponse, InitializeResponse::class.java)");
            this.cache = (InitializeResponse)object;
        }
        boolean bl2 = false;
        this.stickyDeviceExperiments = new LinkedHashMap();
        if (cachedDeviceValues != null) {
            Type type2 = new TypeToken<Map<String, APIDynamicConfig>>(){}.getType();
            Map<String, APIDynamicConfig> map = (Map<String, APIDynamicConfig>)this.gson.fromJson(cachedDeviceValues, type2);
            this.stickyDeviceExperiments = map == null ? this.stickyDeviceExperiments : map;
        }
        this.loadAndResetStickyUserValues(userID);
    }

    public final void loadAndResetStickyUserValues(@Nullable String newUserID) {
        String cachedUserValues = Statsig.INSTANCE.getSharedPrefs$build_release().getString("Statsig.STICKY_USER_EXPERIMENTS", null);
        boolean bl = false;
        this.stickyUserExperiments = new StickyUserExperiments(newUserID, new LinkedHashMap());
        if (cachedUserValues != null) {
            StickyUserExperiments stickyUserExperiments;
            StickyUserExperiments stickyUserExperiments2;
            StickyUserExperiments stickyUserExperiments3 = (StickyUserExperiments)this.gson.fromJson(cachedUserValues, StickyUserExperiments.class);
            if (stickyUserExperiments3 == null) {
                stickyUserExperiments2 = this.stickyUserExperiments;
                if (stickyUserExperiments2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"stickyUserExperiments");
                    throw null;
                }
                stickyUserExperiments = stickyUserExperiments2;
            } else {
                stickyUserExperiments = stickyUserExperiments3;
            }
            stickyUserExperiments3 = this.stickyUserExperiments = stickyUserExperiments;
            if (stickyUserExperiments3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stickyUserExperiments");
                throw null;
            }
            if (!Intrinsics.areEqual((Object)stickyUserExperiments3.getUserID(), (Object)newUserID)) {
                boolean bl2 = false;
                this.stickyUserExperiments = new StickyUserExperiments(newUserID, new LinkedHashMap());
                stickyUserExperiments2 = this.stickyUserExperiments;
                if (stickyUserExperiments2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"stickyUserExperiments");
                    throw null;
                }
                String string = this.gson.toJson((Object)stickyUserExperiments2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(stickyUserExperiments)");
                Statsig.INSTANCE.saveStringToSharedPrefs$build_release("Statsig.STICKY_USER_EXPERIMENTS", string);
            }
        }
    }

    public final void save(@NotNull InitializeResponse data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.cache = data;
        String string = this.gson.toJson((Object)this.cache);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(cache)");
        Statsig.INSTANCE.saveStringToSharedPrefs$build_release("Statsig.INITIALIZE_RESPONSE", string);
    }

    @NotNull
    public final APIFeatureGate checkGate(@NotNull String gateName) {
        Object object;
        String hashName;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)gateName, (String)"gateName");
                hashName = StatsigUtil.INSTANCE.getHashedString(gateName);
                if (this.cache.getFeatureGates() == null) break block2;
                object = this.cache.getFeatureGates();
                Intrinsics.checkNotNull(object);
                if (object.containsKey(hashName)) break block3;
            }
            return new APIFeatureGate(gateName, false, "", null, 8, null);
        }
        Map<String, APIFeatureGate> map = this.cache.getFeatureGates();
        Intrinsics.checkNotNull(map);
        object = map.get(hashName);
        return object == null ? new APIFeatureGate(gateName, false, "", null, 8, null) : object;
    }

    @NotNull
    public final DynamicConfig getConfig(@NotNull String configName) {
        String string;
        Object object;
        APIDynamicConfig config;
        String hashName;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
                hashName = StatsigUtil.INSTANCE.getHashedString(configName);
                if (this.cache.getConfigs() == null) break block5;
                Map<String, APIDynamicConfig> map = this.cache.getConfigs();
                Intrinsics.checkNotNull(map);
                if (map.containsKey(hashName)) break block6;
            }
            return new DynamicConfig(configName, null, null, null, 14, null);
        }
        Map<String, String>[] mapArray = this.cache.getConfigs();
        Intrinsics.checkNotNull(mapArray);
        APIDynamicConfig aPIDynamicConfig = config = mapArray.get(hashName);
        Map<String, String>[] mapArray2 = mapArray = aPIDynamicConfig == null ? null : aPIDynamicConfig.getValue();
        if (mapArray == null) {
            boolean bl = false;
            object = MapsKt.emptyMap();
        } else {
            object = mapArray;
        }
        mapArray = config;
        String string2 = mapArray == null ? "" : ((string = mapArray.getRuleID()) == null ? "" : string);
        APIDynamicConfig aPIDynamicConfig2 = config;
        mapArray = aPIDynamicConfig2 == null ? null : aPIDynamicConfig2.getSecondaryExposures();
        return new DynamicConfig(configName, (Map<String, ? extends Object>)object, string2, (Map<String, String>[])(mapArray == null ? new Map[]{} : mapArray));
    }

    @NotNull
    public final DynamicConfig getExperiment(@NotNull String experimentName, boolean keepDeviceValue) {
        APIDynamicConfig latestValue;
        Intrinsics.checkNotNullParameter((Object)experimentName, (String)"experimentName");
        String hashName = StatsigUtil.INSTANCE.getHashedString(experimentName);
        Object object = this.stickyUserExperiments;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stickyUserExperiments");
            throw null;
        }
        APIDynamicConfig aPIDynamicConfig = object.getExperiments().get(hashName);
        APIDynamicConfig stickyValue = aPIDynamicConfig == null ? this.stickyDeviceExperiments.get(hashName) : aPIDynamicConfig;
        object = this.cache.getConfigs();
        APIDynamicConfig aPIDynamicConfig2 = latestValue = object == null ? null : (APIDynamicConfig)object.get(hashName);
        if (!keepDeviceValue || Intrinsics.areEqual((Object)((object = latestValue) == null ? null : Boolean.valueOf(object.isExperimentActive())), (Object)false)) {
            this.removeStickyValue(hashName);
            return this.getConfig(experimentName);
        }
        if (stickyValue != null) {
            Map<String, APIDynamicConfig> map;
            APIDynamicConfig aPIDynamicConfig3 = stickyValue;
            object = aPIDynamicConfig3.getValue();
            if (object == null) {
                boolean bl = false;
                map = MapsKt.emptyMap();
            } else {
                map = object;
            }
            object = stickyValue;
            Object object2 = object.getRuleID();
            Object object3 = object2 == null ? "" : object2;
            object2 = stickyValue;
            object = ((APIDynamicConfig)object2).getSecondaryExposures();
            return new DynamicConfig(experimentName, map, (String)object3, object == null ? new Map[]{} : object);
        }
        if (latestValue != null && latestValue.isExperimentActive() && latestValue.isUserInExperiment()) {
            object = latestValue;
            if (object.isDeviceBased()) {
                object = this.stickyDeviceExperiments;
                boolean bl = false;
                object.put((String)hashName, (APIDynamicConfig)latestValue);
            } else {
                object = this.stickyUserExperiments;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"stickyUserExperiments");
                    throw null;
                }
                object = object.getExperiments();
                boolean bl = false;
                object.put(hashName, latestValue);
            }
            this.cacheStickyValues();
        }
        return this.getConfig(experimentName);
    }

    private final void removeStickyValue(String key) {
        StickyUserExperiments stickyUserExperiments = this.stickyUserExperiments;
        if (stickyUserExperiments == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stickyUserExperiments");
            throw null;
        }
        stickyUserExperiments.getExperiments().remove(key);
        this.stickyDeviceExperiments.remove(key);
        this.cacheStickyValues();
    }

    private final void cacheStickyValues() {
        StickyUserExperiments stickyUserExperiments = this.stickyUserExperiments;
        if (stickyUserExperiments == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stickyUserExperiments");
            throw null;
        }
        String string = this.gson.toJson((Object)stickyUserExperiments);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(stickyUserExperiments)");
        Statsig.INSTANCE.saveStringToSharedPrefs$build_release("Statsig.STICKY_USER_EXPERIMENTS", string);
        string = this.gson.toJson(this.stickyDeviceExperiments);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(stickyDeviceExperiments)");
        Statsig.INSTANCE.saveStringToSharedPrefs$build_release("Statsig.STICKY_DEVICE_EXPERIMENTS", string);
    }
}

