/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import android.app.Activity;
import android.app.Application;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Base64;
import com.google.gson.Gson;
import com.statsig.androidsdk.DynamicConfig;
import com.statsig.androidsdk.InitializeResponse;
import com.statsig.androidsdk.LogEvent;
import com.statsig.androidsdk.NetworkKt;
import com.statsig.androidsdk.StatsigCallback;
import com.statsig.androidsdk.StatsigId;
import com.statsig.androidsdk.StatsigKt;
import com.statsig.androidsdk.StatsigLogger;
import com.statsig.androidsdk.StatsigMetadata;
import com.statsig.androidsdk.StatsigOptions;
import com.statsig.androidsdk.StatsigState;
import com.statsig.androidsdk.StatsigUser;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/statsig/androidsdk/Statsig;", "", "()V", "Companion", "build_release"})
public final class Statsig {
    private static final String INITIALIZE_RESPONSE_KEY = "INITIALIZE_RESPONSE";
    private static StatsigState state;
    private static StatsigUser user;
    private static StatsigCallback callback;
    private static Application application;
    private static String sdkKey;
    private static StatsigOptions options;
    private static StatsigLogger logger;
    private static StatsigMetadata statsigMetadata;
    private static SharedPreferences sharedPrefs;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initialize(@NotNull Application application, @NotNull String sdkKey, @NotNull StatsigCallback callback, @Nullable StatsigUser user, @Nullable StatsigOptions options) {
        Companion.initialize(application, sdkKey, callback, user, options);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initialize(@NotNull Application application, @NotNull String sdkKey, @NotNull StatsigCallback callback, @Nullable StatsigUser user) {
        com.statsig.androidsdk.Statsig$Companion.initialize$default(Companion, application, sdkKey, callback, user, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initialize(@NotNull Application application, @NotNull String sdkKey, @NotNull StatsigCallback callback) {
        com.statsig.androidsdk.Statsig$Companion.initialize$default(Companion, application, sdkKey, callback, null, null, 24, null);
    }

    @JvmStatic
    public static final boolean checkGate(@NotNull String gateName) {
        return Companion.checkGate(gateName);
    }

    @JvmStatic
    @Nullable
    public static final DynamicConfig getConfig(@NotNull String configName) {
        return Companion.getConfig(configName);
    }

    @JvmStatic
    @JvmOverloads
    public static final void logEvent(@NotNull String eventName, @Nullable Double value, @Nullable Map<String, String> metadata) {
        Companion.logEvent(eventName, value, metadata);
    }

    @JvmStatic
    @JvmOverloads
    public static final void logEvent(@NotNull String eventName, @Nullable Double value) {
        com.statsig.androidsdk.Statsig$Companion.logEvent$default(Companion, eventName, value, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void logEvent(@NotNull String eventName) {
        com.statsig.androidsdk.Statsig$Companion.logEvent$default(Companion, eventName, null, null, 6, null);
    }

    @JvmStatic
    public static final void logEvent(@NotNull String eventName, @NotNull String value, @Nullable Map<String, String> metadata) {
        Companion.logEvent(eventName, value, metadata);
    }

    @JvmStatic
    public static final void logEvent(@NotNull String eventName, @NotNull Map<String, String> metadata) {
        Companion.logEvent(eventName, metadata);
    }

    @JvmStatic
    public static final void updateUser(@Nullable StatsigUser user, @NotNull StatsigCallback callback) {
        Companion.updateUser(user, callback);
    }

    @JvmStatic
    public static final void shutdown() {
        Companion.shutdown();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001/B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J8\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\b\u0010 \u001a\u00020\u001aH\u0002J9\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\u0016\b\u0002\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010&H\u0007\u00a2\u0006\u0002\u0010'J0\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0016\b\u0002\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010&H\u0007J$\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00042\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040&H\u0007J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u00020\u001a2\b\u0010,\u001a\u0004\u0018\u00010*H\u0002J\b\u0010-\u001a\u00020\u001aH\u0007J\u001a\u0010.\u001a\u00020\u001a2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/statsig/androidsdk/Statsig$Companion;", "", "()V", "INITIALIZE_RESPONSE_KEY", "", "application", "Landroid/app/Application;", "callback", "Lcom/statsig/androidsdk/StatsigCallback;", "logger", "Lcom/statsig/androidsdk/StatsigLogger;", "options", "Lcom/statsig/androidsdk/StatsigOptions;", "sdkKey", "sharedPrefs", "Landroid/content/SharedPreferences;", "state", "Lcom/statsig/androidsdk/StatsigState;", "statsigMetadata", "Lcom/statsig/androidsdk/StatsigMetadata;", "user", "Lcom/statsig/androidsdk/StatsigUser;", "checkGate", "", "gateName", "clearCache", "", "getConfig", "Lcom/statsig/androidsdk/DynamicConfig;", "configName", "getHashedString", "initialize", "loadFromCache", "logEvent", "eventName", "value", "", "metadata", "", "(Ljava/lang/String;Ljava/lang/Double;Ljava/util/Map;)V", "saveToCache", "initializeData", "Lcom/statsig/androidsdk/InitializeResponse;", "setState", "result", "shutdown", "updateUser", "StatsigActivityLifecycleListener", "build_release"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        public final void initialize(@NotNull Application application, @NotNull String sdkKey, @NotNull StatsigCallback callback, @Nullable StatsigUser user, @Nullable StatsigOptions options) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            if (!StringsKt.startsWith$default((String)sdkKey, (String)"client-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)sdkKey, (String)"test-", (boolean)false, (int)2, null)) {
                throw (Throwable)new Exception("Invalid SDK Key provided.  You must provide a client SDK Key from the API Key page of your Statsig console");
            }
            Statsig.application = application;
            sdkKey = sdkKey;
            user = user;
            callback = callback;
            if (options == null) {
                options = new StatsigOptions(null, 1, null);
            } else {
                options = options;
            }
            SharedPreferences sharedPreferences = application.getSharedPreferences("STATSIG", 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"application.getSharedPre\u2026G\", Context.MODE_PRIVATE)");
            sharedPrefs = sharedPreferences;
            Statsig.statsigMetadata = new StatsigMetadata(null, null, null, null, null, null, null, null, null, null, 1023, null);
            StatsigMetadata statsigMetadata = statsigMetadata;
            if (statsigMetadata == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
            }
            SharedPreferences sharedPreferences2 = sharedPrefs;
            if (sharedPreferences2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPrefs");
            }
            statsigMetadata.setStableID(StatsigId.Companion.getStableID(sharedPreferences2));
            int stringID = application.getApplicationInfo().labelRes;
            StatsigMetadata statsigMetadata2 = statsigMetadata;
            if (statsigMetadata2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
            }
            statsigMetadata2.setAppIdentifier(stringID == 0 ? ((Object)application.getApplicationInfo().nonLocalizedLabel).toString() : application.getString(stringID));
            try {
                PackageInfo packageInfo = application.getPackageManager().getPackageInfo(application.getPackageName(), 0);
                Intrinsics.checkNotNullExpressionValue((Object)packageInfo, (String)"application.packageManag\u2026plication.packageName, 0)");
                PackageInfo pInfo = packageInfo;
                StatsigMetadata statsigMetadata3 = statsigMetadata;
                if (statsigMetadata3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
                }
                statsigMetadata3.setAppVersion(pInfo.versionName);
            }
            catch (PackageManager.NameNotFoundException pInfo) {
                // empty catch block
            }
            Application application2 = application;
            if (application2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"application");
            }
            application2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new StatsigActivityLifecycleListener());
            StatsigOptions statsigOptions = options;
            if (statsigOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            String string = statsigOptions.getApi();
            StatsigMetadata statsigMetadata4 = statsigMetadata;
            if (statsigMetadata4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
            }
            logger = new StatsigLogger(sdkKey, string, statsigMetadata4);
            this.loadFromCache();
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"user", (Object)user);
            StatsigMetadata statsigMetadata5 = statsigMetadata;
            if (statsigMetadata5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
            }
            pairArray[1] = TuplesKt.to((Object)"statsigMetadata", (Object)statsigMetadata5);
            Map body = MapsKt.mapOf((Pair[])pairArray);
            StatsigOptions statsigOptions2 = options;
            if (statsigOptions2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            String string2 = statsigOptions2.getApi();
            String string3 = new Gson().toJson((Object)body);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Gson().toJson(body)");
            NetworkKt.apiPost(string2, "initialize", sdkKey, string3, (Function1<? super InitializeResponse, Unit>)((Function1)new Function1<InitializeResponse, Unit>(this){

                public final void invoke(@Nullable InitializeResponse p1) {
                    com.statsig.androidsdk.Statsig$Companion.access$setState((Companion)this.receiver, p1);
                }
            }));
        }

        public static /* synthetic */ void initialize$default(Companion companion, Application application, String string, StatsigCallback statsigCallback, StatsigUser statsigUser, StatsigOptions statsigOptions, int n, Object object) {
            if ((n & 8) != 0) {
                statsigUser = null;
            }
            if ((n & 0x10) != 0) {
                statsigOptions = null;
            }
            companion.initialize(application, string, statsigCallback, statsigUser, statsigOptions);
        }

        @JvmStatic
        @JvmOverloads
        public final void initialize(@NotNull Application application, @NotNull String sdkKey, @NotNull StatsigCallback callback, @Nullable StatsigUser user) {
            com.statsig.androidsdk.Statsig$Companion.initialize$default(this, application, sdkKey, callback, user, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void initialize(@NotNull Application application, @NotNull String sdkKey, @NotNull StatsigCallback callback) {
            com.statsig.androidsdk.Statsig$Companion.initialize$default(this, application, sdkKey, callback, null, null, 24, null);
        }

        @JvmStatic
        public final boolean checkGate(@NotNull String gateName) {
            Intrinsics.checkNotNullParameter((Object)gateName, (String)"gateName");
            if (state == null) {
                return false;
            }
            StatsigState statsigState = state;
            Intrinsics.checkNotNull((Object)statsigState);
            boolean gateValue = statsigState.checkGate(this.getHashedString(gateName));
            StatsigLogger statsigLogger = logger;
            if (statsigLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            statsigLogger.logGateExposure(gateName, gateValue, user);
            return gateValue;
        }

        @JvmStatic
        @Nullable
        public final DynamicConfig getConfig(@NotNull String configName) {
            Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
            if (state == null) {
                return null;
            }
            StatsigState statsigState = state;
            Intrinsics.checkNotNull((Object)statsigState);
            DynamicConfig config = statsigState.getConfig(this.getHashedString(configName));
            if (config != null) {
                StatsigLogger statsigLogger = logger;
                if (statsigLogger == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                }
                statsigLogger.logConfigExposure(configName, config.getGroup(), user);
            }
            return config;
        }

        @JvmStatic
        @JvmOverloads
        public final void logEvent(@NotNull String eventName, @Nullable Double value, @Nullable Map<String, String> metadata) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            LogEvent event = new LogEvent(eventName);
            event.setValue(value);
            event.setMetadata(metadata);
            event.setUser(user);
            StatsigLogger statsigLogger = logger;
            if (statsigLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            statsigLogger.log(event);
        }

        public static /* synthetic */ void logEvent$default(Companion companion, String string, Double d, Map map, int n, Object object) {
            if ((n & 2) != 0) {
                d = null;
            }
            if ((n & 4) != 0) {
                map = null;
            }
            companion.logEvent(string, d, (Map<String, String>)map);
        }

        @JvmStatic
        @JvmOverloads
        public final void logEvent(@NotNull String eventName, @Nullable Double value) {
            com.statsig.androidsdk.Statsig$Companion.logEvent$default(this, eventName, value, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void logEvent(@NotNull String eventName) {
            com.statsig.androidsdk.Statsig$Companion.logEvent$default(this, eventName, null, null, 6, null);
        }

        @JvmStatic
        public final void logEvent(@NotNull String eventName, @NotNull String value, @Nullable Map<String, String> metadata) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            LogEvent event = new LogEvent(eventName);
            event.setValue(value);
            event.setMetadata(metadata);
            event.setUser(user);
            StatsigLogger statsigLogger = logger;
            if (statsigLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            statsigLogger.log(event);
        }

        public static /* synthetic */ void logEvent$default(Companion companion, String string, String string2, Map map, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            companion.logEvent(string, string2, (Map<String, String>)map);
        }

        @JvmStatic
        public final void logEvent(@NotNull String eventName, @NotNull Map<String, String> metadata) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
            LogEvent event = new LogEvent(eventName);
            event.setValue(null);
            event.setMetadata(metadata);
            event.setUser(user);
            StatsigLogger statsigLogger = logger;
            if (statsigLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            statsigLogger.log(event);
        }

        @JvmStatic
        public final void updateUser(@Nullable StatsigUser user, @NotNull StatsigCallback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            StatsigLogger statsigLogger = logger;
            if (statsigLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            statsigLogger.flush();
            this.clearCache();
            user = user;
            callback = callback;
            StatsigMetadata statsigMetadata = statsigMetadata;
            if (statsigMetadata == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
            }
            SharedPreferences sharedPreferences = sharedPrefs;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPrefs");
            }
            statsigMetadata.setStableID(StatsigId.Companion.getNewStableID(sharedPreferences));
            StatsigMetadata statsigMetadata2 = statsigMetadata;
            if (statsigMetadata2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
            }
            statsigMetadata2.setSessionID(StatsigId.Companion.getNewSessionID());
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"user", (Object)user);
            StatsigMetadata statsigMetadata3 = statsigMetadata;
            if (statsigMetadata3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statsigMetadata");
            }
            pairArray[1] = TuplesKt.to((Object)"statsigMetadata", (Object)statsigMetadata3);
            Map body = MapsKt.mapOf((Pair[])pairArray);
            StatsigOptions statsigOptions = options;
            if (statsigOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            String string = statsigOptions.getApi();
            String string2 = sdkKey;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sdkKey");
            }
            String string3 = new Gson().toJson((Object)body);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Gson().toJson(body)");
            NetworkKt.apiPost(string, "initialize", string2, string3, (Function1<? super InitializeResponse, Unit>)((Function1)new Function1<InitializeResponse, Unit>(this){

                public final void invoke(@Nullable InitializeResponse p1) {
                    com.statsig.androidsdk.Statsig$Companion.access$setState((Companion)this.receiver, p1);
                }
            }));
        }

        @JvmStatic
        public final void shutdown() {
            StatsigLogger statsigLogger = logger;
            if (statsigLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            statsigLogger.flush();
        }

        private final void loadFromCache() {
            InitializeResponse json;
            SharedPreferences sharedPreferences = sharedPrefs;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPrefs");
            }
            String string = sharedPreferences.getString(Statsig.INITIALIZE_RESPONSE_KEY, null);
            if (string == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.sharedPrefs.getStri\u2026ONSE_KEY, null) ?: return");
            String cachedResponse = string;
            InitializeResponse initializeResponse = json = (InitializeResponse)new Gson().fromJson(cachedResponse, InitializeResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)initializeResponse, (String)"json");
            state = new StatsigState(initializeResponse);
        }

        private final void saveToCache(InitializeResponse initializeData) {
            String json = new Gson().toJson((Object)initializeData);
            SharedPreferences sharedPreferences = sharedPrefs;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPrefs");
            }
            sharedPreferences.edit().putString(Statsig.INITIALIZE_RESPONSE_KEY, json).commit();
        }

        private final void clearCache() {
            SharedPreferences sharedPreferences = sharedPrefs;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPrefs");
            }
            sharedPreferences.edit().remove(Statsig.INITIALIZE_RESPONSE_KEY);
        }

        private final void setState(InitializeResponse result) {
            if (result != null) {
                state = new StatsigState(result);
                this.saveToCache(result);
            }
            StatsigCallback cb = callback;
            callback = null;
            if (cb != null) {
                BuildersKt.launch$default((CoroutineScope)StatsigKt.access$getCoroutineScope$p(), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(cb, null){
                    int label;
                    final /* synthetic */ StatsigCallback $cb;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$cb.onStatsigReady();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.$cb = statsigCallback;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }

        private final String getHashedString(String gateName) {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String string = gateName;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] input = byArray;
            byte[] bytes = md.digest(input);
            String string3 = Base64.encodeToString((byte[])bytes, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"android.util.Base64.enco\u2026roid.util.Base64.NO_WRAP)");
            return string3;
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$setState(Companion $this, InitializeResponse result) {
            $this.setState(result);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/statsig/androidsdk/Statsig$Companion$StatsigActivityLifecycleListener;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "()V", "onActivityCreated", "", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "build_release"})
        private static final class StatsigActivityLifecycleListener
        implements Application.ActivityLifecycleCallbacks {
            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Companion.shutdown();
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }
        }
    }
}

