/*
 * Decompiled with CFR 0.152.
 */
package br.com.stant.libraries.uilibrary.components.severitylevelindicatorview;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import br.com.stant.libraries.uilibrary.R;
import br.com.stant.libraries.uilibrary.components.severitylevelindicatorview.SeverityLevelEnum;
import br.com.stant.libraries.uilibrary.components.severitylevelindicatorview.SeverityLevelIndicatorViewContract;
import br.com.stant.libraries.uilibrary.databinding.SeverityLevelIndicatorViewBinding;

public class SeverityLevelIndicatorView
extends LinearLayout
implements SeverityLevelIndicatorViewContract {
    SeverityLevelIndicatorViewBinding mSeverityLevelIndicatorViewBinding;
    Integer LIGHT_SEVERITY_SHAPE = R.drawable.shape_round_yellow_little_balls;
    Integer SERIOUS_SEVERITY_SHAPE = R.drawable.shape_round_orange_little_balls;
    Integer GRAVE_SEVERITY_SHAPE = R.drawable.shape_round_red_little_balls;
    Integer EMPTY_GREY_SEVERITY_SHAPE = R.drawable.shape_round_gray_little_balls;
    private Integer mSeverityLevelValue;
    private SeverityLevelIndicatorViewContract.OnChangeSeverityLevel mOnChangeSeverityLevel;

    public SeverityLevelIndicatorView(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.mSeverityLevelIndicatorViewBinding = (SeverityLevelIndicatorViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.severity_level_indicator_view, (ViewGroup)this, (boolean)true);
        }
    }

    public SeverityLevelIndicatorView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mSeverityLevelIndicatorViewBinding = (SeverityLevelIndicatorViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.severity_level_indicator_view, (ViewGroup)this, (boolean)true);
        this.mSeverityLevelIndicatorViewBinding.setHandler(this);
    }

    @Override
    public void setSeverityLevel(SeverityLevelEnum severityLevelEnum) {
        if (severityLevelEnum == null) {
            severityLevelEnum = SeverityLevelEnum.VERY_LIGHT;
        }
        this.showCorrectSeverityLevelBallsConfiguration(severityLevelEnum);
    }

    private void showCorrectSeverityLevelBallsConfiguration(SeverityLevelEnum severityLevelEnum) {
        switch (severityLevelEnum) {
            case VERY_LIGHT: {
                this.setVeryLightSeverityLevelConfiguration((View)this);
                break;
            }
            case LIGHT: {
                this.setLightSeverityLevelConfiguration((View)this);
                break;
            }
            case NORMAL: {
                this.setNormalSeverityLevelConfiguration((View)this);
                break;
            }
            case SERIOUS: {
                this.setSeriousSeverityLevelConfiguration((View)this);
                break;
            }
            case GRAVE: {
                this.setGraveSeverityLevelConfiguration((View)this);
                break;
            }
            default: {
                this.setVeryLightSeverityLevelConfiguration((View)this);
            }
        }
    }

    @Override
    public void setVeryLightSeverityLevelConfiguration(View view) {
        this.setSeverityLevelConfiguration(this.LIGHT_SEVERITY_SHAPE, this.EMPTY_GREY_SEVERITY_SHAPE, this.EMPTY_GREY_SEVERITY_SHAPE, this.EMPTY_GREY_SEVERITY_SHAPE, this.EMPTY_GREY_SEVERITY_SHAPE);
        this.onChangeSeverityLevel(SeverityLevelEnum.VERY_LIGHT);
    }

    @Override
    public void setLightSeverityLevelConfiguration(View view) {
        this.setSeverityLevelConfiguration(this.LIGHT_SEVERITY_SHAPE, this.LIGHT_SEVERITY_SHAPE, this.EMPTY_GREY_SEVERITY_SHAPE, this.EMPTY_GREY_SEVERITY_SHAPE, this.EMPTY_GREY_SEVERITY_SHAPE);
        this.onChangeSeverityLevel(SeverityLevelEnum.LIGHT);
    }

    @Override
    public void setNormalSeverityLevelConfiguration(View view) {
        this.setSeverityLevelConfiguration(this.SERIOUS_SEVERITY_SHAPE, this.SERIOUS_SEVERITY_SHAPE, this.SERIOUS_SEVERITY_SHAPE, this.EMPTY_GREY_SEVERITY_SHAPE, this.EMPTY_GREY_SEVERITY_SHAPE);
        this.onChangeSeverityLevel(SeverityLevelEnum.NORMAL);
    }

    @Override
    public void setSeriousSeverityLevelConfiguration(View view) {
        this.setSeverityLevelConfiguration(this.SERIOUS_SEVERITY_SHAPE, this.SERIOUS_SEVERITY_SHAPE, this.SERIOUS_SEVERITY_SHAPE, this.SERIOUS_SEVERITY_SHAPE, this.EMPTY_GREY_SEVERITY_SHAPE);
        this.onChangeSeverityLevel(SeverityLevelEnum.SERIOUS);
    }

    @Override
    public void setGraveSeverityLevelConfiguration(View view) {
        this.setSeverityLevelConfiguration(this.GRAVE_SEVERITY_SHAPE, this.GRAVE_SEVERITY_SHAPE, this.GRAVE_SEVERITY_SHAPE, this.GRAVE_SEVERITY_SHAPE, this.GRAVE_SEVERITY_SHAPE);
        this.onChangeSeverityLevel(SeverityLevelEnum.GRAVE);
    }

    private void setSeverityLevelConfiguration(Integer firstBallLevel, Integer secondBallLevel, Integer thirdBallLevel, Integer fourthBallLevel, Integer fifthBallLevel) {
        this.mSeverityLevelIndicatorViewBinding.severityLevelIndicatorViewFirstBallView.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)firstBallLevel));
        this.mSeverityLevelIndicatorViewBinding.severityLevelIndicatorViewSecondBallView.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)secondBallLevel));
        this.mSeverityLevelIndicatorViewBinding.severityLevelIndicatorViewThirdBallView.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)thirdBallLevel));
        this.mSeverityLevelIndicatorViewBinding.severityLevelIndicatorViewFourthBallView.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)fourthBallLevel));
        this.mSeverityLevelIndicatorViewBinding.severityLevelIndicatorViewFifthBallView.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)fifthBallLevel));
    }

    @Override
    public void onChangeSeverityLevel(SeverityLevelEnum severityLevelEnum) {
        if (this.mOnChangeSeverityLevel != null) {
            this.mOnChangeSeverityLevel.onChange(severityLevelEnum);
        }
    }

    @Override
    public void setOnChangeSeverityLevel(SeverityLevelIndicatorViewContract.OnChangeSeverityLevel onChangeSeverityLevel) {
        this.mOnChangeSeverityLevel = onChangeSeverityLevel;
    }
}

