/*
 * Decompiled with CFR 0.152.
 */
package br.com.stant.libraries.uilibrary.components.selecttimepickerview;

import android.app.Dialog;
import android.content.Context;
import android.databinding.DataBindingUtil;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import br.com.stant.libraries.uilibrary.R;
import br.com.stant.libraries.uilibrary.components.selecttimepickerview.SelectTimePickerViewContract;
import br.com.stant.libraries.uilibrary.databinding.SelectTimePickerViewBinding;
import br.com.stant.libraries.uilibrary.databinding.SelectTimePickerViewTimeNumberPickerDialogBinding;
import java.text.DecimalFormat;

public class SelectTimePickerView
extends LinearLayout
implements SelectTimePickerViewContract {
    private SelectTimePickerViewBinding mSelectTimePickerViewBinding;
    private SelectTimePickerViewTimeNumberPickerDialogBinding mSelectTimePickerViewTimeNumberPickerDialogBinding;
    private Dialog mTimeNumberPickerDialog;
    private SelectTimePickerViewContract.OnTimeSelected mOnTimeSelected;

    public SelectTimePickerView(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.init(context);
        }
    }

    public SelectTimePickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.init(context);
        }
    }

    public SelectTimePickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.init(context);
        }
    }

    private void init(Context context) {
        this.mSelectTimePickerViewBinding = (SelectTimePickerViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.select_time_picker_view, (ViewGroup)this, (boolean)true);
        this.setOnClickListener(this::openTimePickerDialog);
        this.initializeTimePickerDialogConfiguration();
    }

    private void initializeTimePickerDialogConfiguration() {
        this.mTimeNumberPickerDialog = new Dialog(this.getContext(), R.style.NumberPickerDialogTheme);
        this.mSelectTimePickerViewTimeNumberPickerDialogBinding = (SelectTimePickerViewTimeNumberPickerDialogBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.select_time_picker_view_time_number_picker_dialog, null, (boolean)false);
        this.mTimeNumberPickerDialog.setContentView(this.mSelectTimePickerViewTimeNumberPickerDialogBinding.getRoot());
        this.mSelectTimePickerViewTimeNumberPickerDialogBinding.setHandler(this);
        this.numberPickerDialogConfiguration();
        this.setTime(0, 0);
    }

    public void numberPickerDialogConfiguration() {
        this.mSelectTimePickerViewTimeNumberPickerDialogBinding.selectTimePickerViewTimeNumberPickerDialogReworkHoursNumberPicker.setMaxValue(100);
        this.mSelectTimePickerViewTimeNumberPickerDialogBinding.selectTimePickerViewTimeNumberPickerDialogReworkHoursNumberPicker.setMinValue(0);
        this.mSelectTimePickerViewTimeNumberPickerDialogBinding.selectTimePickerViewTimeNumberPickerDialogReworkMinutesNumberPicker.setMaxValue(59);
        this.mSelectTimePickerViewTimeNumberPickerDialogBinding.selectTimePickerViewTimeNumberPickerDialogReworkMinutesNumberPicker.setMinValue(0);
        this.mSelectTimePickerViewTimeNumberPickerDialogBinding.selectTimePickerViewTimeNumberPickerDialogOkButtonTextView.setOnClickListener(this::onPressOkButtonOnNumberPickerDialog);
    }

    @Override
    public void openTimePickerDialog(View view) {
        this.mTimeNumberPickerDialog.show();
    }

    @Override
    public void setOnTimeSelected(SelectTimePickerViewContract.OnTimeSelected onTimeSelected) {
        this.mOnTimeSelected = onTimeSelected;
    }

    @Override
    public void setTime(int hour, int minute) {
        String newTimeTextValue = this.getFormattedTimeValue(hour, minute);
        this.updateTimeTextValue(newTimeTextValue);
    }

    @Override
    public String getCurrentTime() {
        return this.mSelectTimePickerViewBinding.getTimeText();
    }

    @Override
    public void onPressOkButtonOnNumberPickerDialog(View view) {
        String newTimeTextValue = this.getTimeTextValueSelectedByPicker();
        this.updateTimeTextValue(newTimeTextValue);
        this.mTimeNumberPickerDialog.dismiss();
        if (this.mOnTimeSelected != null) {
            this.mOnTimeSelected.onTimeSelected(newTimeTextValue);
        }
    }

    private String getTimeTextValueSelectedByPicker() {
        int newHourValue = this.mSelectTimePickerViewTimeNumberPickerDialogBinding.selectTimePickerViewTimeNumberPickerDialogReworkHoursNumberPicker.getValue();
        int newMinutesValue = this.mSelectTimePickerViewTimeNumberPickerDialogBinding.selectTimePickerViewTimeNumberPickerDialogReworkMinutesNumberPicker.getValue();
        return this.getFormattedTimeValue(newHourValue, newMinutesValue);
    }

    private void updateTimeTextValue(String newTimeTextValue) {
        this.mSelectTimePickerViewBinding.setTimeText(newTimeTextValue);
    }

    private String getFormattedTimeValue(int hourValue, int minuteValue) {
        DecimalFormat df = new DecimalFormat("#00");
        String formattedTime = "";
        formattedTime = formattedTime.concat(String.valueOf(df.format(hourValue)));
        formattedTime = formattedTime.concat(":");
        formattedTime = formattedTime.concat(String.valueOf(df.format(minuteValue)));
        return formattedTime;
    }
}

