/*
 * Decompiled with CFR 0.152.
 */
package br.com.stant.libraries.uilibrary.components.infoactioncardview;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import br.com.stant.libraries.uilibrary.R;
import br.com.stant.libraries.uilibrary.components.infoactioncardview.InfoActionCardViewContract;
import br.com.stant.libraries.uilibrary.databinding.InfoActionCardViewBinding;
import br.com.stant.libraries.uilibrary.utils.ViewUtils;

public class InfoActionCardView
extends CardView
implements InfoActionCardViewContract {
    private InfoActionCardViewBinding mInfoActionCardViewBinding;
    private InfoActionCardViewContract.OnClickActionCardListener mOnClickActionCardListener;
    private Integer actionActiveTextColor;
    private String mInfoText;
    private String mActionText;

    public InfoActionCardView(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.mInfoActionCardViewBinding = (InfoActionCardViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.info_action_card_view, (ViewGroup)this, (boolean)true);
        }
    }

    public InfoActionCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.init(context, attrs);
        }
    }

    public InfoActionCardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.init(context, attrs);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        this.mInfoActionCardViewBinding = (InfoActionCardViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.info_action_card_view, (ViewGroup)this, (boolean)true);
        this.mInfoActionCardViewBinding.setHandler(this);
        this.getAttributes(attrs);
        this.setAttributes();
    }

    public void setInfoText(String infoText) {
        this.mInfoText = infoText;
        this.mInfoActionCardViewBinding.setInfoText(infoText);
    }

    public void setActionText(String actionText) {
        this.mActionText = actionText;
        this.mInfoActionCardViewBinding.setActionText(actionText);
    }

    private void getAttributes(AttributeSet attrs) {
        this.mInfoText = ViewUtils.getStringFromTypedArray(this.getContext(), R.styleable.InfoActionCardView, attrs, R.styleable.InfoActionCardView_infoText);
        this.mActionText = ViewUtils.getStringFromTypedArray(this.getContext(), R.styleable.InfoActionCardView, attrs, R.styleable.InfoActionCardView_actionName);
    }

    private void setAttributes() {
        this.setInfoText(this.mInfoText);
        this.setActionText(this.mActionText);
    }

    @Override
    public void setOnClickActionCardListener(InfoActionCardViewContract.OnClickActionCardListener onClickActionCardListener) {
        this.setActiveColorOnAction();
        this.mOnClickActionCardListener = onClickActionCardListener;
    }

    private void setActiveColorOnAction() {
        if (this.actionActiveTextColor != null) {
            this.mInfoActionCardViewBinding.infoActionCardViewActionText.setTextColor(this.actionActiveTextColor.intValue());
        } else {
            this.mInfoActionCardViewBinding.infoActionCardViewActionText.setTextColor(this.getResources().getColor(R.color.green_base));
        }
    }

    @Override
    public void onClickActionCard(View view) {
        if (this.mOnClickActionCardListener != null) {
            this.mOnClickActionCardListener.onClick();
        }
    }

    @Override
    public void setActionActiveTextColor(int color2) {
        this.actionActiveTextColor = this.getResources().getColor(color2);
    }
}

