/*
 * Decompiled with CFR 0.152.
 */
package br.com.stant.libraries.uilibrary.components.expandabletextview;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.text.Layout;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import br.com.stant.libraries.uilibrary.R;
import br.com.stant.libraries.uilibrary.components.expandabletextview.ExpandableTextViewContract;
import br.com.stant.libraries.uilibrary.components.expandabletextview.ExpandableTextViewStyleEnum;
import br.com.stant.libraries.uilibrary.databinding.ExpandableTextViewBinding;

public class ExpandableTextView
extends LinearLayout
implements ExpandableTextViewContract {
    private ExpandableTextViewBinding mExpandableTextViewBinding;

    public ExpandableTextView(Context context) {
        super(context);
        this.init(context);
    }

    public ExpandableTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ExpandableTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mExpandableTextViewBinding = (ExpandableTextViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.expandable_text_view, (ViewGroup)this, (boolean)true);
        this.mExpandableTextViewBinding.setHandler(this);
        this.hideLongText((View)this);
        this.hiddenArrowIconIfIsEllipsize();
    }

    @Override
    public void expandLongText(View view) {
        this.mExpandableTextViewBinding.setTextViewState(ExpandableTextViewStyleEnum.EXPANDABLE);
    }

    @Override
    public void hideLongText(View view) {
        this.mExpandableTextViewBinding.setTextViewState(ExpandableTextViewStyleEnum.HIDDEN);
    }

    @Override
    public void setNoLongTextState() {
        this.mExpandableTextViewBinding.expandableTextViewArrowContainerLinearLayout.setVisibility(8);
    }

    @Override
    public void setActiveLongTextState() {
        this.mExpandableTextViewBinding.expandableTextViewArrowContainerLinearLayout.setVisibility(0);
    }

    @Override
    public void setExpandableText(String expandableText) {
        this.mExpandableTextViewBinding.setExpandableText(expandableText);
    }

    private void hiddenArrowIconIfIsEllipsize() {
        ViewTreeObserver vto = this.mExpandableTextViewBinding.expandableTextViewHiddenTextView.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(() -> {
            Layout layout2 = this.mExpandableTextViewBinding.expandableTextViewHiddenTextView.getLayout();
            if (layout2 != null) {
                int lines = layout2.getLineCount();
                int ellipsisCount = layout2.getEllipsisCount(lines - 1);
                if (ellipsisCount == 0) {
                    this.setNoLongTextState();
                } else if (ellipsisCount > 0) {
                    this.setActiveLongTextState();
                }
            }
        });
    }
}

