/*
 * Decompiled with CFR 0.152.
 */
package br.com.stant.libraries.uilibrary.components.actionbuttonview;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import br.com.stant.libraries.uilibrary.R;
import br.com.stant.libraries.uilibrary.components.actionbuttonview.ActionButtonCardStyleEnum;
import br.com.stant.libraries.uilibrary.components.actionbuttonview.ActionButtonViewContract;
import br.com.stant.libraries.uilibrary.databinding.ActionButtonViewBinding;
import br.com.stant.libraries.uilibrary.utils.ViewUtils;

public class ActionButtonView
extends CardView
implements ActionButtonViewContract {
    private ActionButtonViewBinding mActionButtonViewBinding;
    private ActionButtonViewContract.OnClickActionButtonListener mOnClickActionButtonListener;
    private String mActionText;
    private Drawable mActionIcon;
    private int mCardStyle;

    public ActionButtonView(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.mActionButtonViewBinding = (ActionButtonViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.action_button_view, (ViewGroup)this, (boolean)true);
        }
    }

    public ActionButtonView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.init(context, attrs);
        }
    }

    public ActionButtonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.init(context, attrs);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        this.mActionButtonViewBinding = (ActionButtonViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.action_button_view, (ViewGroup)this, (boolean)true);
        this.setBackground(this.getResources().getDrawable(R.drawable.shape_white_with_green_border));
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.getAttributesFromView(attrs);
        this.setAttributesIntoView();
    }

    public void getAttributesFromView(AttributeSet attrs) {
        this.mActionText = ViewUtils.getStringFromTypedArray(this.getContext(), R.styleable.ActionButtonView, attrs, R.styleable.ActionButtonView_actionText);
        this.mActionIcon = ViewUtils.getDrawableFromTypedArray(this.getContext(), R.styleable.ActionButtonView, attrs, R.styleable.ActionButtonView_actionIcon);
        this.mCardStyle = ViewUtils.getIntegerFromTypedArray(this.getContext(), R.styleable.ActionButtonView, attrs, R.styleable.ActionButtonView_cardStyle);
    }

    public void setAttributesIntoView() {
        this.mActionButtonViewBinding.setHandler(this);
        this.mActionButtonViewBinding.setActionName(this.mActionText);
        this.mActionButtonViewBinding.setActionIcon(this.mActionIcon);
        this.setCardStyle(this.mCardStyle);
    }

    @Override
    public void setCardStyle(int cardStyleReference) {
        if (cardStyleReference == ActionButtonCardStyleEnum.VERTICAL.getValue()) {
            this.setVerticalViewStyleCard();
        } else if (cardStyleReference == ActionButtonCardStyleEnum.HORIZONTAL.getValue()) {
            this.setHorizontalViewStyleCard();
        }
    }

    @Override
    public void setOnClickActionButtonListener(ActionButtonViewContract.OnClickActionButtonListener onClickActionButtonListener) {
        this.mOnClickActionButtonListener = onClickActionButtonListener;
    }

    @Override
    public void onClickActionButton(View view) {
        this.mOnClickActionButtonListener.onClick();
    }

    private void setVerticalViewStyleCard() {
        this.mActionButtonViewBinding.actionButtonViewHorizontalContainerLinearLayout.setVisibility(8);
        this.mActionButtonViewBinding.actionButtonViewVerticalContainerLinearLayout.setVisibility(0);
    }

    private void setHorizontalViewStyleCard() {
        this.mActionButtonViewBinding.actionButtonViewHorizontalContainerLinearLayout.setVisibility(0);
        this.mActionButtonViewBinding.actionButtonViewVerticalContainerLinearLayout.setVisibility(8);
    }
}

