/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.resolver;

import com.github.mustachejava.MustacheResolver;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class ClasspathResolver
implements MustacheResolver {
    private final String resourceRoot;

    public ClasspathResolver() {
        this.resourceRoot = null;
    }

    public ClasspathResolver(String resourceRoot) {
        if (!resourceRoot.endsWith("/")) {
            resourceRoot = resourceRoot + "/";
        }
        this.resourceRoot = resourceRoot;
    }

    @Override
    public Reader getReader(String resourceName) {
        String name;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        InputStream is = ccl.getResourceAsStream(name = (this.resourceRoot == null ? "" : this.resourceRoot) + resourceName);
        if (is == null) {
            is = ClasspathResolver.class.getClassLoader().getResourceAsStream(name);
        }
        if (is != null) {
            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }
        return null;
    }
}

