/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.util;

import com.github.mustachejava.MustacheException;
import java.io.IOException;
import java.io.Writer;

public class HtmlEscaper {
    private static char[] AMP = "&amp;".toCharArray();
    private static char[] LT = "&lt;".toCharArray();
    private static char[] GT = "&gt;".toCharArray();
    private static char[] DQ = "&quot;".toCharArray();
    private static char[] SQ = "&#39;".toCharArray();
    private static char[][] LT_13 = new char[14][];

    public static void escape(String value, Writer writer) {
        try {
            int length = value.length();
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                if (c <= '\r') {
                    writer.write(LT_13[c]);
                    continue;
                }
                if (c >= '\"' && c <= '>') {
                    switch (c) {
                        case '&': {
                            writer.write(AMP);
                            break;
                        }
                        case '<': {
                            writer.write(LT);
                            break;
                        }
                        case '>': {
                            writer.write(GT);
                            break;
                        }
                        case '\"': {
                            writer.write(DQ);
                            break;
                        }
                        case '\'': {
                            writer.write(SQ);
                            break;
                        }
                        default: {
                            writer.write(c);
                            break;
                        }
                    }
                    continue;
                }
                writer.write(c);
            }
        }
        catch (IOException e) {
            throw new MustacheException("Failed to encode value: " + value);
        }
    }

    static {
        for (int i = 0; i < LT_13.length; ++i) {
            HtmlEscaper.LT_13[i] = ("&#" + String.valueOf(i) + ";").toCharArray();
        }
    }
}

