/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.codes;

import com.github.mustachejava.Code;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.DefaultCode;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ExecutorService;

public class PartialCode
extends DefaultCode {
    private final DefaultMustacheFactory cf;
    private final ExecutorService les;
    protected final String extension;
    protected Mustache partial;

    protected PartialCode(TemplateContext tc, DefaultMustacheFactory cf, Mustache mustache, String type, String variable) {
        super(tc, cf.getObjectHandler(), mustache, variable, type);
        this.cf = cf;
        int index = tc.file().lastIndexOf(".");
        this.extension = index == -1 ? "" : tc.file().substring(index);
        this.les = cf.getExecutorService();
    }

    public PartialCode(TemplateContext tc, DefaultMustacheFactory cf, String variable) {
        this(tc, cf, null, ">", variable);
    }

    @Override
    public void identity(Writer writer) {
        try {
            if (this.name != null) {
                super.tag(writer, this.type);
            }
            this.appendText(writer);
        }
        catch (IOException e) {
            throw new MustacheException(e);
        }
    }

    @Override
    public Code[] getCodes() {
        return this.partial == null ? null : this.partial.getCodes();
    }

    @Override
    public void setCodes(Code[] newcodes) {
        this.partial.setCodes(newcodes);
    }

    @Override
    public Writer execute(Writer writer, Object[] scopes) {
        return this.appendText(this.partial.execute(writer, scopes));
    }

    @Override
    public synchronized void init() {
        this.partial = this.cf.compile(this.partialName());
        if (this.partial == null) {
            throw new MustacheException("Failed to compile partial: " + this.name);
        }
    }

    protected String partialName() {
        return this.name + this.extension;
    }
}

