/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.reflect;

import com.github.mustachejava.Binding;
import com.github.mustachejava.Code;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.reflect.BaseObjectHandler;
import com.github.mustachejava.reflect.Guard;
import com.github.mustachejava.reflect.GuardedBinding;
import com.github.mustachejava.reflect.MissingWrapper;
import com.github.mustachejava.reflect.ReflectionWrapper;
import com.github.mustachejava.reflect.guards.ClassGuard;
import com.github.mustachejava.reflect.guards.DepthGuard;
import com.github.mustachejava.reflect.guards.DotGuard;
import com.github.mustachejava.reflect.guards.MapGuard;
import com.github.mustachejava.reflect.guards.NullGuard;
import com.github.mustachejava.reflect.guards.WrappedGuard;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ReflectionObjectHandler
extends BaseObjectHandler {
    protected static final Method MAP_METHOD;

    public static Object unwrap(ObjectHandler oh, int scopeIndex, Wrapper[] wrappers, Object[] scopes) throws GuardException {
        Object scope = oh.coerce(scopes[scopeIndex]);
        if (wrappers != null) {
            for (Wrapper wrapper : wrappers) {
                scope = oh.coerce(wrapper.call(new Object[]{scope}));
            }
        }
        return scope;
    }

    @Override
    public Wrapper find(String name, Object[] scopes) {
        Wrapper wrapper = null;
        int length = scopes.length;
        ArrayList<Guard> guards = new ArrayList<Guard>(scopes.length);
        guards.add(this.createDepthGuard(length));
        block2: for (int i = length - 1; i >= 0; --i) {
            Wrapper[] foundWrappers;
            int dotIndex;
            Object scope = scopes[i];
            if (scope == null) continue;
            guards.add(this.createClassGuard(i, scope));
            ArrayList<Wrapper> wrappers = null;
            String subname = name;
            while ((dotIndex = subname.indexOf(46)) != -1) {
                String lookup = subname.substring(0, dotIndex);
                subname = subname.substring(dotIndex + 1);
                guards.add(this.createDotGuard(i, scope, lookup));
                ArrayList<Guard> wrapperGuard = new ArrayList<Guard>(1);
                wrapper = this.findWrapper(0, null, wrapperGuard, scope, lookup);
                if (wrappers == null) {
                    wrappers = new ArrayList<Wrapper>();
                }
                if (wrapper != null) {
                    wrappers.add(wrapper);
                    try {
                        scope = this.coerce(wrapper.call(new Object[]{scope}));
                    }
                    catch (GuardException e) {
                        throw new AssertionError((Object)e);
                    }
                } else {
                    wrapperGuard.add(this.createClassGuard(0, scope));
                    guards.add(this.createWrappedGuard(i, wrappers, wrapperGuard));
                    continue block2;
                }
                if (scope != null) continue;
                wrapperGuard.add(this.createNullGuard());
                guards.add(this.createWrappedGuard(i, wrappers, wrapperGuard));
                break;
            }
            if (wrappers != null) {
                guards.add(this.createWrappedGuard(i, (List<Wrapper>)wrappers, Arrays.asList(this.createClassGuard(0, scope))));
            }
            if ((wrapper = this.findWrapper(i, foundWrappers = wrappers == null ? null : wrappers.toArray(new Wrapper[wrappers.size()]), guards, scope, subname)) != null) break;
        }
        return wrapper == null ? this.createMissingWrapper(guards) : wrapper;
    }

    protected Wrapper findWrapper(int scopeIndex, Wrapper[] wrappers, List<Guard> guards, Object scope, String name) {
        AccessibleObject member;
        if ((scope = this.coerce(scope)) == null) {
            return null;
        }
        if (scope instanceof Map) {
            Map map = (Map)scope;
            if (map.containsKey(name)) {
                guards.add(this.createMapGuard(scopeIndex, wrappers, name, true));
                return this.createWrapper(scopeIndex, wrappers, guards, MAP_METHOD, new Object[]{name});
            }
            guards.add(this.createMapGuard(scopeIndex, wrappers, name, false));
            if (!this.areMethodsAccessible(map)) {
                return null;
            }
        }
        return (member = this.findMember(scope.getClass(), name)) == null ? null : this.createWrapper(scopeIndex, wrappers, guards, member, null);
    }

    protected MissingWrapper createMissingWrapper(List<Guard> guards) {
        return new MissingWrapper(guards.toArray(new Guard[guards.size()]));
    }

    protected DotGuard createDotGuard(int i, Object scope, String lookup) {
        return new DotGuard(lookup, i, scope);
    }

    protected WrappedGuard createWrappedGuard(int i, List<Wrapper> wrappers, List<Guard> wrapperGuard) {
        return new WrappedGuard(this, i, wrappers, wrapperGuard);
    }

    protected NullGuard createNullGuard() {
        return new NullGuard();
    }

    protected DepthGuard createDepthGuard(int length) {
        return new DepthGuard(length);
    }

    protected ClassGuard createClassGuard(int i, Object scope) {
        return new ClassGuard(i, scope);
    }

    protected MapGuard createMapGuard(int scopeIndex, Wrapper[] wrappers, String name, boolean contains) {
        return new MapGuard(this, scopeIndex, name, contains, wrappers);
    }

    protected Wrapper createWrapper(int scopeIndex, Wrapper[] wrappers, List<? extends Guard> guard, AccessibleObject member, Object[] arguments) {
        return new ReflectionWrapper(scopeIndex, wrappers, guard.toArray(new Guard[guard.size()]), member, arguments, this);
    }

    @Override
    public Binding createBinding(String name, TemplateContext tc, Code code) {
        return new GuardedBinding(this, name, tc, code);
    }

    protected boolean areMethodsAccessible(Map<?, ?> map) {
        return false;
    }

    static {
        try {
            MAP_METHOD = Map.class.getMethod("get", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

