/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.codes;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.FragmentKey;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.DefaultCode;
import com.github.mustachejava.util.LatchedWriter;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class ValueCode
extends DefaultCode {
    private final boolean encoded;
    private final ExecutorService les;

    @Override
    public void identity(Writer writer) {
        try {
            if (this.name != null) {
                writer.write(this.tc.startChars());
                if (!this.encoded) {
                    writer.write("{");
                }
                writer.write(this.type);
                writer.write(this.name);
                if (!this.encoded) {
                    writer.write("}");
                }
                writer.write(this.tc.endChars());
            }
            this.appendText(writer);
        }
        catch (IOException e) {
            throw new MustacheException(e);
        }
    }

    public ValueCode(TemplateContext tc, DefaultMustacheFactory df, String variable, boolean encoded) {
        super(tc, df, null, variable, "");
        this.encoded = encoded;
        this.les = df.getExecutorService();
    }

    @Override
    public Writer execute(Writer writer, Object[] scopes) {
        Object object = this.get(scopes);
        if (object != null) {
            try {
                if (object instanceof Function) {
                    this.handleFunction(writer, (Function)object, scopes);
                } else {
                    if (object instanceof Callable) {
                        return this.handleCallable(writer, (Callable)object, scopes);
                    }
                    this.execute(writer, this.oh.stringify(object));
                }
            }
            catch (Exception e) {
                throw new MustacheException("Failed to get value for " + this.name + " at line " + this.tc.file() + ":" + this.tc.line(), e);
            }
        }
        return super.execute(writer, scopes);
    }

    protected Writer handleCallable(Writer writer, final Callable callable, Object[] scopes) throws Exception {
        if (this.les == null) {
            this.execute(writer, this.oh.stringify(callable.call()));
            return super.execute(writer, scopes);
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new MustacheException("Failed to flush writer", e);
        }
        final LatchedWriter latchedWriter = new LatchedWriter(writer);
        final Writer finalWriter = writer;
        this.les.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object call = callable.call();
                    ValueCode.this.execute(finalWriter, call == null ? null : ValueCode.this.oh.stringify(call));
                    latchedWriter.done();
                }
                catch (Throwable e) {
                    latchedWriter.failed(e);
                }
            }
        });
        return super.execute((Writer)latchedWriter, scopes);
    }

    protected void handleFunction(Writer writer, Function function, Object[] scopes) throws IOException {
        String value;
        Object newtemplate = function.apply(null);
        if (newtemplate != null) {
            String templateText = newtemplate.toString();
            StringWriter sw = new StringWriter();
            this.df.getFragment(new FragmentKey(new TemplateContext("{{", "}}", this.tc.file(), this.tc.line()), templateText)).execute((Writer)sw, scopes).close();
            value = sw.toString();
        } else {
            value = "";
        }
        this.execute(writer, value);
    }

    protected void execute(Writer writer, String value) throws IOException {
        if (this.encoded) {
            this.df.encode(value, writer);
        } else {
            writer.write(value);
        }
    }
}

