/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.TemplateContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicInteger;

public class MustacheParser {
    public static final String DEFAULT_SM = "{{";
    public static final String DEFAULT_EM = "}}";
    private MustacheFactory cf;

    protected MustacheParser(MustacheFactory cf) {
        this.cf = cf;
    }

    public Mustache compile(String file) {
        Reader reader = this.cf.getReader(file);
        if (reader == null) {
            throw new MustacheException("Failed to find: " + file);
        }
        return this.compile(reader, file);
    }

    public Mustache compile(Reader reader, String file) {
        return this.compile(reader, file, DEFAULT_SM, DEFAULT_EM);
    }

    public Mustache compile(Reader reader, String file, String sm, String em) {
        return this.compile(reader, null, new AtomicInteger(0), file, sm, em);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Mustache compile(Reader reader, String tag, AtomicInteger currentLine, String file, String sm, String em) throws MustacheException {
        if (reader == null) {
            throw new MustacheException("Reader is null");
        }
        br = reader.markSupported() != false ? reader : new BufferedReader(reader);
        try {
            mv = this.cf.createMustacheVisitor();
            onlywhitespace = true;
            iterable = currentLine.get() != 0;
            currentLine.compareAndSet(0, 1);
            out = new StringBuilder();
lbl11:
            // 8 sources

            while (true) {
                try {}
                catch (IOException e) {
                    throw new MustacheException("Failed to read", e);
                }
                break;
            }
        }
        catch (MustacheException me) {
            try {
                br.close();
                throw me;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw me;
        }
        while (true) {
            block42: {
                block43: {
                    if ((c = br.read()) == -1) break block43;
                    if (c == 13) continue;
                    if (c == 10) {
                        currentLine.incrementAndGet();
                        if (!iterable || iterable && !onlywhitespace) {
                            out.append("\n");
                        }
                        out = this.write(mv, out, file, currentLine.intValue());
                        iterable = false;
                        onlywhitespace = true;
                        continue;
                    }
                    if (c != sm.charAt(0)) ** GOTO lbl43
                    br.mark(1);
                    if (sm.length() == 1 || br.read() == sm.charAt(1)) {
                        sb = new StringBuilder();
                        break block42;
                    } else {
                        br.reset();
lbl43:
                        // 2 sources

                        onlywhitespace = onlywhitespace != false && (c == 32 || c == 9 || c == 13);
                        out.append((char)c);
                        continue;
                    }
                }
                this.write(mv, out, file, currentLine.intValue());
                br.close();
                mv.eof(new TemplateContext(sm, em, file, currentLine.get()));
                return mv.mustache(new TemplateContext(sm, em, file, 0));
            }
            while ((c = br.read()) != -1) {
                br.mark(1);
                if (c == em.charAt(0)) {
                    if (em.length() <= 1 || br.read() == em.charAt(1)) break;
                    br.reset();
                }
                sb.append((char)c);
            }
            command = this.cf.translate(sb.toString());
            ch = command.charAt(0);
            variable = command.substring(1).trim();
            switch (ch) {
                case '#': 
                case '$': 
                case '<': 
                case '^': {
                    line = currentLine.get();
                    mustache = this.compile(br, variable, currentLine, file, sm, em);
                    lines = currentLine.get() - line;
                    if (!onlywhitespace || lines == 0) {
                        this.write(mv, out, file, currentLine.intValue());
                    }
                    out = new StringBuilder();
                    switch (ch) {
                        case '#': {
                            mv.iterable(new TemplateContext(sm, em, file, line), variable, mustache);
                            break;
                        }
                        case '^': {
                            mv.notIterable(new TemplateContext(sm, em, file, line), variable, mustache);
                            break;
                        }
                        case '<': {
                            mv.extend(new TemplateContext(sm, em, file, line), variable, mustache);
                            break;
                        }
                        case '$': {
                            mv.name(new TemplateContext(sm, em, file, line), variable, mustache);
                            break;
                        }
                    }
                    iterable = lines != 0;
                    ** GOTO lbl11
                }
                case '/': {
                    if (!onlywhitespace) {
                        this.write(mv, out, file, currentLine.intValue());
                    }
                    if (variable.equals(tag) != false) return mv.mustache(new TemplateContext(sm, em, file, 0));
                    throw new MustacheException("Mismatched start/end tags: " + tag + " != " + variable + " in " + file + ":" + currentLine);
                }
                case '>': {
                    out = this.write(mv, out, file, currentLine.intValue());
                    mv.partial(new TemplateContext(sm, em, file, currentLine.get()), variable);
                    ** GOTO lbl11
                }
                case '{': {
                    out = this.write(mv, out, file, currentLine.intValue());
                    name = variable;
                    if (em.charAt(1) != '}') {
                        name = variable.substring(0, variable.length() - 1);
                    } else if (br.read() != 125) {
                        throw new MustacheException("Improperly closed variable in " + file + ":" + currentLine);
                    }
                    finalName = name;
                    mv.value(new TemplateContext(sm, em, file, currentLine.get()), finalName, false);
                    ** GOTO lbl11
                }
                case '&': {
                    out = this.write(mv, out, file, currentLine.intValue());
                    mv.value(new TemplateContext(sm, em, file, currentLine.get()), variable, false);
                    ** GOTO lbl11
                }
                case '%': {
                    if (!onlywhitespace) {
                        out = this.write(mv, out, file, currentLine.intValue());
                    }
                    if ((index = variable.indexOf(" ")) == -1) {
                        pragma = variable;
                        args = null;
                    } else {
                        pragma = variable.substring(0, index);
                        args = variable.substring(index + 1);
                    }
                    mv.pragma(new TemplateContext(sm, em, file, currentLine.get()), pragma, args);
                    ** GOTO lbl11
                }
                case '!': {
                    out = this.write(mv, out, file, currentLine.intValue());
                    ** GOTO lbl11
                }
                case '=': {
                    out = this.write(mv, out, file, currentLine.intValue());
                    delimiters = command.replaceAll("\\s+", "");
                    length = delimiters.length();
                    if (length > 6) throw new MustacheException("Invalid delimiter string");
                    if (length / 2 * 2 != length) {
                        throw new MustacheException("Invalid delimiter string");
                    }
                    sm = delimiters.substring(1, length / 2);
                    em = delimiters.substring(length / 2, length - 1);
                    ** continue;
                }
            }
            if (c == -1) {
                throw new MustacheException("Improperly closed variable in " + file + ":" + currentLine);
            }
            out = this.write(mv, out, file, currentLine.intValue());
            mv.value(new TemplateContext(sm, em, file, currentLine.get()), command.trim(), true);
        }
    }

    private StringBuilder write(MustacheVisitor mv, StringBuilder out, String file, int line) {
        String text = out.toString();
        mv.write(new TemplateContext(null, null, file, line), text);
        return new StringBuilder();
    }
}

