/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava;

import com.github.mustachejava.Code;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.DefaultCode;
import com.github.mustachejava.codes.DefaultMustache;
import com.github.mustachejava.codes.ExtendCode;
import com.github.mustachejava.codes.ExtendNameCode;
import com.github.mustachejava.codes.IterableCode;
import com.github.mustachejava.codes.NotIterableCode;
import com.github.mustachejava.codes.PartialCode;
import com.github.mustachejava.codes.ValueCode;
import com.github.mustachejava.codes.WriteCode;
import java.util.LinkedList;
import java.util.List;

public class DefaultMustacheVisitor
implements MustacheVisitor {
    private static final Code EOF = new DefaultCode();
    protected final List<Code> list = new LinkedList<Code>();
    protected DefaultMustacheFactory cf;

    public DefaultMustacheVisitor(DefaultMustacheFactory cf) {
        this.cf = cf;
    }

    @Override
    public Mustache mustache(TemplateContext templateContext) {
        return new DefaultMustache(templateContext, this.cf, this.list.toArray(new Code[this.list.size()]), templateContext.file());
    }

    @Override
    public void iterable(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new IterableCode(templateContext, this.cf, mustache, variable));
    }

    @Override
    public void notIterable(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new NotIterableCode(templateContext, this.cf, mustache, variable));
    }

    @Override
    public void name(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new ExtendNameCode(templateContext, this.cf, mustache, variable));
    }

    @Override
    public void partial(TemplateContext templateContext, String variable) {
        TemplateContext partialTC = new TemplateContext("{{", "}}", templateContext.file(), templateContext.line());
        this.list.add(new PartialCode(partialTC, this.cf, variable));
    }

    @Override
    public void value(TemplateContext templateContext, String variable, boolean encoded) {
        this.list.add(new ValueCode(templateContext, this.cf, variable, encoded));
    }

    @Override
    public void write(TemplateContext templateContext, String text) {
        if (text.length() > 0) {
            int size = this.list.size();
            if (size > 0) {
                Code code = this.list.get(size - 1);
                code.append(text);
            } else {
                this.list.add(new WriteCode(text));
            }
        }
    }

    @Override
    public void eof(TemplateContext templateContext) {
        this.list.add(EOF);
    }

    @Override
    public void extend(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new ExtendCode(templateContext, this.cf, mustache, variable));
    }
}

